<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\events;


/**
 * Utility class to handle critical section by locking files on files system. 
 * 
 * @author Sylvain Desplat
 */
class SMTEventMessageManagerLockHandler
{
    const LOCK_TEST_ON_DEMAND_EVENT_FILE = "/../../tmp/testOnDemandEvent.lock";
    const LOCK_MEASURE_ON_DEMAND_EVENT_FILE = "/../../tmp/measureOnDemandEvent.lock";
    const LOCK_ALARM_EVENT_FILE = "/../../tmp/alarmEvent.lock";
    const LOCK_ACTIVITY_EVENT_FILE = "/../../tmp/activityEvent.lock";
    const LOCK_LINKTESTUPDATE_EVENT_FILE = "/../../tmp/linkTestUpdateEvent.lock";
    const LOCK_CONVERSATION_FILE = "/../../tmp/conversation.lock";
    
    /**
     * @var string
     */
    private static $testOnDemandFile = NULL;
    /**
     * @var string
     */
    private static $measureOnDemandFile = NULL;        
    /**
     * @var string
     */    
    private static $alarmFile = NULL;
    /**
     * @var string
     */    
    private static $activityFile = NULL;
    /**
     * @var string
     */
    private static $linkTestUpdateFile = NULL;    
    /**
     * @var string
     */
    private static $conversationFile = NULL;

        
    private static function getLockTestOnDemandEventFile()
    {
    	if ( self::$testOnDemandFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_TEST_ON_DEMAND_EVENT_FILE, "w+");
    		 
    		self::$testOnDemandFile = ( $handle != FALSE)? $handle : NULL;
    	}    	
    	return self::$testOnDemandFile;
    }
    
    private static function getLockMeasureOnDemandEventFile()
    {
    	if ( self::$measureOnDemandFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_MEASURE_ON_DEMAND_EVENT_FILE, "w+");
    		 
    		self::$measureOnDemandFile = ( $handle != FALSE)? $handle : NULL;
    	}
    	return self::$measureOnDemandFile;
    }    

    private static function getLockAlarmEventFile()
    {
    	if ( self::$alarmFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_ALARM_EVENT_FILE, "w+");
    		 
    		self::$alarmFile = ( $handle != FALSE)? $handle : NULL;
    	}
    	return self::$alarmFile;
    }
        
    private static function getLockLinkTestUpdateEventFile()
    {
    	if ( self::$linkTestUpdateFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_LINKTESTUPDATE_EVENT_FILE, "w+");
    		 
    		self::$linkTestUpdateFile = ( $handle != FALSE)? $handle : NULL;
    	}
    	return self::$linkTestUpdateFile;
    }
    
    private static function getLockActivityEventFile()
    {
    	if ( self::$activityFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_ACTIVITY_EVENT_FILE, "w+");
    		 
    		self::$activityFile = ( $handle != FALSE)? $handle : NULL;
    	}
    	return self::$activityFile;
    }
    
    private static function getLockConversationFile()
    {
    	if ( self::$conversationFile == NULL )
    	{
    		$handle = fopen( __DIR__.self::LOCK_CONVERSATION_FILE, "w+");
    		 
    		self::$conversationFile = ( $handle != FALSE)? $handle : NULL;
    	}
    	return self::$conversationFile;
    }
    
    
    public static function acquireTestOnDemandLock()
    {
        $retries = 0;
        $max_retries = 25;
        
        //SMTLogger::getInstance()->trace( "acquireTestOnDemandLock" );
        
        // keep trying to get a lock as long as possible ( max 5s)
        do
        {
        	if ($retries > 0)
        	{
        		usleep( 1000 * ( $retries*$retries ) );
        	}
        	$retries += 1;
        } while ( (!flock(self::getLockTestOnDemandEventFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
        
        return ($retries < $max_retries);        
    }
    
    public static function releaseTestOnDemandLock()
    {
        //SMTLogger::getInstance()->trace( "releaseTestOnDemandLock" );
    	return (isset(self::$testOnDemandFile) && self::$testOnDemandFile != NULL)? flock( self::$testOnDemandFile, LOCK_UN ) : TRUE;
    }   

    public static function acquireMeasureOnDemandLock()
    {
        $retries = 0;
        $max_retries = 25;
        
        //SMTLogger::getInstance()->trace( "acquireMeasureOnDemandLock" );
        
        // keep trying to get a lock as long as possible ( max 5s)
        do
        {
        	if ($retries > 0)
        	{
        		usleep( 1000 * ( $retries*$retries ) );
        	}
        	$retries += 1;
        } while ( (!flock(self::getLockMeasureOnDemandEventFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
        
        return ($retries < $max_retries);        
    }
    
    public static function releaseMeasureOnDemandLock()
    {
        //SMTLogger::getInstance()->trace( "releaseMeasureOnDemandLock" );
    	return (isset(self::$measureOnDemandFile) && self::$measureOnDemandFile != NULL)? flock( self::$measureOnDemandFile, LOCK_UN ) : TRUE;
    }    
    
    public static function acquireAlarmLock()
    {
        $retries = 0;
        $max_retries = 25;
        
        //SMTLogger::getInstance()->trace( "acquireAlarmLock" );
        
        // keep trying to get a lock as long as possible ( max 5s )
        do
        {
        	if ($retries > 0)
        	{
        		usleep( 1000 * ( $retries*$retries ) );
        	}
        	$retries += 1;
        } while ( (!flock(self::getLockAlarmEventFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
        
        return ($retries < $max_retries);        
    }    
    
    public static function releaseAlarmLock()
    {
        //SMTLogger::getInstance()->trace( "releaseAlarmLock" );
    	return (isset(self::$alarmFile) && self::$alarmFile != NULL)? flock( self::$alarmFile, LOCK_UN ) : TRUE;
    }

    public static function acquireActivityLock()
    {
        $retries = 0;
        $max_retries = 25;
        
//         SMTLogger::getInstance()->trace( "acquireActivityLock" );
        
        // keep trying to get a lock as long as possible ( max 10s)
        do
        {
        	if ($retries > 0)
        	{
        		usleep( 1000 * ( $retries*$retries ) );
        	}
        	$retries += 1;
        } while ( ( !flock(self::getLockActivityEventFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
        
        return ($retries < $max_retries);        
    }
    
    public static function releaseActivityLock()
    {
        //SMTLogger::getInstance()->trace( "releaseActivityLock" );
    	return (isset(self::$activityFile) && self::$activityFile != NULL)? flock( self::$activityFile, LOCK_UN ) : TRUE;
    }    
    
    public static function acquireLinkTestUpdateLock()
    {
    	$retries = 0;
    	$max_retries = 25;
    
    	//SMTLogger::getInstance()->trace( "acquireLinkTestUpdateLock" );
    
    	// keep trying to get a lock as long as possible ( max 5s)
    	do
    	{
    		if ($retries > 0)
    		{
    			usleep( 1000 * ( $retries*$retries ) );
    		}
    		$retries += 1;
    	} while ( (!flock(self::getLockLinkTestUpdateEventFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
    
    	return ($retries < $max_retries);
    }
    
    public static function releaseLinkTestUpdateLock()
    {
    	//SMTLogger::getInstance()->trace( "releaseLinkTestUpdateLock" );
    	return (isset(self::$linkTestUpdateFile) && self::$linkTestUpdateFile != NULL)? flock( self::$linkTestUpdateFile, LOCK_UN ) : TRUE;
    }    

    public static function acquireConversationLock()
    {
    	$retries = 0;
    	$max_retries = 25;
    	
//     	SMTLogger::getInstance()->trace( "acquireConversationLock" );
    
    	// keep trying to get a lock as long as possible ( max 5s)
    	do
    	{
    		if ($retries > 0)
    		{
    			usleep( 1000 * ( $retries*$retries ) );
    		}
    		$retries += 1;
    	} while ( (!flock(self::getLockConversationFile(), LOCK_EX, $eWouldBlock) || $eWouldBlock ) && $retries <= $max_retries);
    
    	return ($retries < $max_retries);
    }
    
    public static function releaseConversationLock()
    {
//         SMTLogger::getInstance()->trace( "releaseConversationLock" );
    	return (isset(self::$conversationFile) && self::$conversationFile != NULL)? flock( self::$conversationFile, LOCK_UN ) : TRUE;
    }    
}

?>