<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\error;

use app\util\SMTException;

use app\http\SMTContext;

use app\parser\SMTSocketException;

/**
 * Factory to create error dtos from application exceptions
 * @author Sylvain Desplat
 *
 */
class SMTRestExceptionFactory
{    
    /**
     * Create an error dto from an application exception.
     * 
     * @param \Exception $e
     * 
     * @return \app\error\SMTRestException
     */
    public static function processException ( \Exception $e, SMTContext $context = NULL )
    {     
        $error = NULL;
        
        if ( $context != NULL )
        {
            // if at the origin of the exception, there was not a problem of connection to OTU application, a reboot pending or a starting pending,
            // generate a new exception from the current one
            if ( $context->isOTUReboot() )
            {
            	$e = new SMTSocketException( SMTSocketException::ERROR_OTU_APPLICATION_REBOOTING, $e->getMessage() );
            }
            else if ( $context->isOTUStarting() )
            {
            	$e = new SMTSocketException( SMTSocketException::ERROR_OTU_APPLICATION_STARTING, $e->getMessage() );
            }
            else if ( $context->isOTUUpgrade() )
            {
            	$e = new SMTSocketException( SMTSocketException::ERROR_OTU_APPLICATION_UPGRADE, $e->getMessage() );
            }
            else if ( $context->isRescueMode() )
            {
            	$e = new SMTSocketException( SMTSocketException::ERROR_OTU_APPLICATION_RESCUE, $e->getMessage() );
            }
            // if at the origin of the exception, there was a problem of connection to OTU application not handle by the previous cases,
            // throw a new socket exception and keep the current exception message.
            else if ( !$context->isOTUAvailable() )
            {
            	$e = new SMTSocketException( SMTSocketException::ERROR_OTU_APPLICATION_NOT_AVAILABLE, $e->getMessage() );
            }
        }
        
        //decode exceptions into REST exceptions
    	if ($e instanceof SMTSocketException )
    	{
    	    if ( $e->getErrorCode() !== NULL)
    	    {
    	        $error = new SMTRestException( SMTSocketException::decodeHTMLCode( $e->getErrorCode() ), $e->getMessage(), $e->getErrorCode(), $e->getTrace() );
    	    }
    	    else
    	    {
                $error = new SMTInternalErrorRestException( $e->getMessage(), $e->getErrorCode() , $e->getTrace() );
    	    }
    	}
    	else if ($e instanceof SMTException )
    	{
    	    $error = new SMTRestException( SMTRestException::decodeHTMLCode( $e->getErrorCode() ), $e->getMessage(), $e->getErrorCode(), $e->getTrace() );
    	}
    	else
    	{
    	    $error = new SMTRestException( SMTRestException::decodeHTMLCode( $e->getCode() ), $e->getMessage(), NULL, $e->getTrace() );
    	}
    	
    	return $error;
    }
    
}
?>