<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\error;

use app\admin\SMTAuthenticationException;

use Luracast\Restler\RestException;

use app\parser\SMTSocketException;

/**
 * Main rest exception class mapping an exception thrown by the application.
 * That rest exception is sent to the client.
 * 
 * @author Sylvain Desplat
 */
class SMTRestException extends RestException
{
    const SERVICE_UNAVAILABLE = 503;
    const INTERNAL_SERVER_ERROR = 500;
    const BAD_REQUEST = 400;
    const UNAUTHORIZED = 401;
    const ACCESS_FORBIDDEN = 403;
    const SERVICE_NOT_FOUND = 404;
    
    protected $moreInfo;       
    
    /**
     * Custom application error code
     * @var string
     */
    protected $internalErrorCode;
    
    /**
     * 
     * @param integer $httpStatus HTTP error code
     * @param string $message Internal application error message
     * @param string $internalErrorCode Internal application error code
     * @param string $moreInfo Additional info
     */
    function __construct( $httpStatus = self::INTERNAL_SERVER_ERROR, $message, $internalErrorCode, $moreInfo = '' )
    {
        parent::__construct( intval( $httpStatus ), $message );
        $this->moreInfo = $moreInfo;
        $this->internalErrorCode = $internalErrorCode;
    }
    
    function getHttpStatus()
    {
        return $this->code;
    }
    
    function getInternalErrorCode()
    {
    	return $this->internalErrorCode;
    }    
    
    /**
     * Translates exception error code in HTML error code
     *
     * @param string $code The exception error code (SMTSocketException)
     *
     * @return string the HTML error code
     */
    public static function decodeHTMLCode( $code )
    {
    	if ( array_key_exists( $code, RestException::$codes ) )
    	{
    		return $code;
    	}
    	switch ( $code )
    	{
            case SMTAuthenticationException::ERROR_BAD_LOGIN:
                return self::UNAUTHORIZED;
        	    break;
            default:
        		return self::INTERNAL_SERVER_ERROR;
        	break;
    	}

    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }    
}

?>