<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\admin;

use Luracast\Restler\RestException;

use app\error\SMTRestException;



/**
 * Otu parser socket exception
 * 
 * @author Sylvain Desplat
 *
 */
class SMTAuthenticationException extends SMTRestException
{
    const ERROR_BAD_LOGIN = "ERROR_BAD_LOGIN";
    const ERROR_FAILED_TO_CHANGE_USER_PASSWORD = "ERROR_FAILED_TO_CHANGE_USER_PASSWORD";
    const ERROR_USER_PASSWORD_NOT_FOUND = "ERROR_USER_PASSWORD_NOT_FOUND";
    const ERROR_SYSTEM_USER_PASSWORD_CANNOT_BE_CHANGED = "ERROR_SYSTEM_USER_PASSWORD_CANNOT_BE_CHANGED";
    const ERROR_FAILED_TO_UPDATE_USER_PASSWORD_FILE = "ERROR_FAILED_TO_UPDATE_USER_PASSWORD_FILE";
    const ERROR_INVALID_USER_NEW_CREDENTIALS = "ERROR_INVALID_USER_NEW_CREDENTIALS";
    
    /**
     *
     * @param string $code integer internal error code or html error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL )
    {
    	parent::__construct( self::decodeHTMLCode( $code ), self::decodeMessage( $code ), $code);
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }

    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        $errorMessage = MSG_BAD_CREDENTIALS;
        
        switch( $code )
        {
            case self::ERROR_BAD_LOGIN:
                $errorMessage = MSG_BAD_CREDENTIALS;
                break;
            case self::ERROR_FAILED_TO_CHANGE_USER_PASSWORD:
            	$errorMessage = MSG_ERROR_FAILED_TO_CHANGE_USER_PASSWORD;
            	break;
        	case self::ERROR_USER_PASSWORD_NOT_FOUND:
        		$errorMessage = MSG_ERROR_USER_PASSWORD_NOT_FOUND;
        		break;
    		case self::ERROR_FAILED_TO_UPDATE_USER_PASSWORD_FILE:
    			$errorMessage = MSG_ERROR_FAILED_TO_UPDATE_USER_PASSWORD_FILE;
    			break;
			case self::ERROR_SYSTEM_USER_PASSWORD_CANNOT_BE_CHANGED:
				$errorMessage = MSG_ERROR_SYSTEM_USER_PASSWORD_CANNOT_BE_CHANGED;
				break;
			case self::ERROR_INVALID_USER_NEW_CREDENTIALS:
			    $errorMessage = MSG_ERROR_INVALID_USER_NEW_CREDENTIALS;
			    break;
            default:
                break;
        }
        return $errorMessage;
    }
    	
	/**
	 * Translates exception error code in HTML error code
	 *
	 * @param string $code The exception error code (SMTAuthenticationException)
	 *
	 * @return integer the HTML error code
	 */
	public static function decodeHTMLCode( $code )
	{
		if ( array_key_exists( $code, RestException::$codes ) )
		{
			$htmlErrorCode = $code;
		}
		else
		{
			$htmlErrorCode = SMTRestException::UNAUTHORIZED;
	
			switch( $code )
			{
			    case self::ERROR_BAD_LOGIN:
					$htmlErrorCode = SMTRestException::UNAUTHORIZED;
					break;
			    default:
			        $htmlErrorCode = SMTRestException::INTERNAL_SERVER_ERROR;
			        break;
			}
		}
		return $htmlErrorCode;
	}
}

?>