#!/bin/sh

#
#  Stub place holder for searching the default key.
#  Replace with key identifier label of the final public   

OTU_AUTHORIZED_KEYS_FILE="/root/.ssh/authorized_keys"

#  TODO - Make DEFAULT_KEY_LOC an environment variable ?
DEFAULT_KEY_LOC="/root/.ssh/default_root_key_4096.pub"

key_status=0
STATUS=0
loc_public_keys_uniq="/tmp/public_keys.uniq"

is_default_key_present () {

    key_status=1
    auth_key_file="/root/.ssh/authorized_keys"
    default_key_loc="/root/.ssh/default_root_key_4096.pub"

    [ ! -z $3 ]  && [ ! -z $2 ] && auth_key_file=$3 && default_key_loc=$2

    if [ -f $auth_key_file ] && [ -f $default_key_loc ]; then
        auth_key_fp=$(ssh-keygen -lf $auth_key_file | awk  '{print $2}')
        def_key_fp=$(ssh-keygen -lf $default_key_loc | awk '{print $2}')

	[[ $auth_key_fp == *$def_key_fp* ]] && key_status=0
    fi
    echo " key_status  $key_status"
}


#  Check the command line arguments
#  If command line:
#      has zero arguments;  script check authorized_keys for the Viavi default root public key
#      used mostly by upgrade script
#
#  If command line has CLRDEF as first argument;
#      request is made to clear the Viavi deafult root key out of the file specified in $3
#
#  If command line has RCN as first argument
#      request is made to add Viavi default root public key into the authorized_keys file
#      only if the authorized_keys file is empty or non-existant
if [ $# -eq 0 ]; then

    echo "-->"
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Checking if default root key is present"
    is_default_key_present 
    if [ $key_status -eq 0 ]; then
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Default root key is present"
        STATUS=0
    else 
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Default root key is not present"
        STATUS=1
    fi

elif [ "$1" == "CLRDEF" ] && [ ! -z "$3" ] && [ -f "$3" ]; then

    sort $3 | uniq > $loc_public_keys_uniq

    #  Check if local file in $3 contains default key    
    is_default_key_present $1 $2 $loc_public_keys_uniq

    if [ $key_status -eq 0 ]; then
        
        num_authorized_keys=$(ssh-keygen -l -f $loc_public_keys_uniq | wc -l)

        if [ $num_authorized_keys -gt 1 ]; then
	    cdn_elk=$(cat $DEFAULT_KEY_LOC | awk '{print $2}')
            newtmp=$(mktemp)
	    cat $3 | grep -v  $cdn_elk  > $newtmp
	    num_filtered_keys=$(cat $3 | grep -v  $cdn_elk  | wc -l)
	    
	    if [ $num_filtered_keys -ge 1 ]; then
	        mv $newtmp $3
                echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Default root key was removed from SSH Edit Selection"
            else
                mv  $loc_public_keys_uniq $3
		echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- The authorized_keys file contains only the default root key."
	    fi
        else
            mv  $loc_public_keys_uniq $3
            echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Default root key was not removed.  The authorized_keys file contains only the default root key."
        fi
    fi
    [ -f $loc_public_keys_uniq ] && rm -f $loc_public_keys_uniq
    STATUS=0

elif [ "$1" == "RCN" ] && [ -f $2 ]; then

    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Handling request to install default root key"

    is_default_key_present
    if [ $key_status -eq 0 ]; then
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Nothing to do. Default root key is present"
        key_status=0
    elif [[ -f $OTU_AUTHORIZED_KEYS_FILE && ! -s $OTU_AUTHORIZED_KEYS_FILE ||  ! -f $OTU_AUTHORIZED_KEYS_FILE ]]; then
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Default root key is not present.  Adding default root key"
#        cat /root/.ssh/default_root_key_4096.pub >> /root/.ssh/authorized_keys
         cat $2 >> $3
        STATUS=0
    else
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Did not add Viavi default root public key.  The authorized_keys file is not empty."
        STATUS=1
    fi

else

    echo "-->"
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Invalid arguments to handle authorized_keys file"
    STATUS=1

fi
exit $STATUS 
