#!/bin/sh

usage () {
        echo "usage:  $0 user_name password"
        exit 1
}

success=1
IN=

if [ ! -z "$1" -a ! -z "$2" ]
then
#    echo "user_name: $1"
#    echo "password: $2"

    if [ -s "/etc/shadow" ]; then
       IN=`cat /etc/shadow | grep "$1"`
    else
       IN=`cat /etc/passwd | grep "$1"`
    fi
else
    usage
fi

#echo "found: $IN"
if [ ! -z "$IN" ]
then
    IFS=':' read -ra password_enc <<< "$IN"
#    echo ${password_enc[1]}
    IFS='$' read -ra password_arr <<< "${password_enc[1]}"
#    echo "algo: ${password_arr[1]}"
#    echo "salt: ${password_arr[2]}"
    encoded_password=`openssl passwd -${password_arr[1]} -salt ${password_arr[2]} "$2"`
#    echo $encoded_password
    [ "${password_enc[1]}" == "$encoded_password" ] && success=0
fi

if [ $success -ne 0 -a "$1" == "installeth" ]
then
    ENH=`upg_environment g Enhanced_Security`
    if [ "$ENH" == "true" ]
    then
        #enhanced security, nothing to check => return failure
        echo "enhanced security"
    else
        encoded_password=`echo -n "$1" | openssl dgst -sha256 -hex`
        IFS=' ' read -ra password_enc <<< "$encoded_password"
#        echo "hex ${password_enc[1]}"
        [ ${password_enc[1]} == "$2" ] && success=0
    fi
fi

echo "result: $success"

exit $success
