#!/bin/bash
#set -x

####################################################################
# openIsuAndFo : opens the ISU's and FO's parsers # without arguments
####################################################################
function openIsuAndFo
{
    export isu=6
    #export fo=5
    # Socket 5 is Fiber Optic's command parser (on 127.0.0.1 port 8002)
    #exec 5<>/dev/tcp/127.0.0.1/8002
    # Socket 6 is Isu's command parser (on 127.0.0.1 port 8000)
    exec 6<>/dev/tcp/127.0.0.1/8000
    send $isu "*rem"
#    echo "*rem">&$isu
#    esr $isu
    #echo "*rem">&$fo
    #echo "debug:suspend off" >&$isu
}
####################################################################
# closeIsuAndFo : close the ISU's and FO's parsers # without arguments 
####################################################################
function closeIsuAndFo
{
    exec $isu<&-
    #exec $isu>&-
    #exec $fo<&-
    #exec $fo>&-
}
####################################################################
# send : send a command to the parser and checks the ESR # 1st parameter : $isu or $fo # 2nd parameter : command to send to the parser 
####################################################################
function send
{
    local rc
    echo -e "$2\n*esr?\n" >&$1
    read rc<&$1
    [ "$rc" == "0" ] || echo "\!\!\!\!\!\!\!\!\!\! WRONG ESR: $rc"
}
####################################################################
# esr : checks the ESR
# 1st parameter : $isu or $fo
####################################################################
function esr
{
    local rc
    echo "*esr?" >&$1
    read rc<&$1
    [ "$rc" == "0" ] || echo "\!\!\!\!\!\!\!\!\!\! WRONG ESR: $rc"
}
####################################################################
# sndrcv : sends a query to the parser, reads the answer and checks 
#          the esr
# 1st parameter : $isu or $fo
# 2nd parameter : query to send to the parser # 3rd parameter : name of the variable to store the answer of the 
#                 query
####################################################################
function sndrcv
{
    local rc
    echo "$2" >&$1
    read rc<&$1
    eval $3="$rc"
    esr $1
}


# Main

openIsuAndFo

sndrcv $isu "SYSTEM:ETHERNET:MODE?" answer
echo -n "Current configuation is: "
echo $answer

if [ "$1" == "CFG1" ] 
   then

   echo "Fall back to default CFG1"
   send $isu 'ISU:DFT "ETH_IP0,ETH_SUBNET0,ETH_GATEWAY0,ETH_DNS0,ETH_EXT_DNS_B0,ETH_EXT_DNS_C0,ETH_DOMAIN0,ETH_SITE0,ETH_MODE"'
   sleep 1
   echo "Restart Ethernet interface"
   send $isu "SYSTEM:ETHERNET:RESTART"
   sndrcv $isu "SYSTEM:ETHERNET:MODE?" answer
   echo -n "Current configuation is now: "
   echo $answer
   fi

if [ "$1" == "DHCP" ] 
   then
   echo "Force DHCP"
   send $isu "SYSTEM:ETHERNET:MODE DHCP"
   echo "Restart Ethernet interface"
   send $isu "SYSTEM:ETHERNET:RESTART"
   sndrcv $isu "SYSTEM:ETHERNET:MODE?" answer
   echo -n "Current configuation is now: "
   echo $answer
   fi

if [ "$1" == "JDSU" ]
   then

   echo "Reset IP address"
   send $isu "SYSTEM:ETHERNET:IPADDRESS CFG2,192,168,0,200"
   echo "Reset IP gateway"
   send $isu "SYSTEM:ETHERNET:IPGATEWAY CFG2,192,168,0,253"
   echo "Reset IP mask"
   send $isu "SYSTEM:ETHERNET:IPMASK CFG2,255,255,255,0"
   echo "Reset DNS 1"
   send $isu "SYSTEM:ETHERNET:DNS CFG2,1,127,0,0,1"
   echo "Reset Domain name"
   send $isu "SYSTEM:ETHERNET:DOMAINNAME CFG2,'"'ds.jdsu.net'"'"
   echo "Reset Site name"
   send $isu "SYSTEM:ETHERNET:SITENAME CFG2,'"'JDSU St Etienne0'"'"
   echo "Fall back to CFG2"
   send $isu "SYSTEM:ETHERNET:MODE CFG2"

   fi 

# Close Isu failed because of network RESTART command
#closeIsuAndFo

