#!/bin/bash

# Grab the raw Solution I2C bus numbers. The busses at "chan_id 1" are the Solution
# side of I2C platform mux.
i2cbusses=($(i2cdetect -l | grep 'chan_id 1' | grep -Po '(?<=^i2c-)\d+'))
for bus in "${i2cbusses[@]}"; do
    # The shim mux is located at address 0x75.
    shim_mux=$(i2cdetect -y "$bus" | grep 75)
    if [[ ! -z $shim_mux ]]; then
        # Load the mux driver at the appropriate bus.
        echo pca9546 0x75 > "/sys/bus/i2c/devices/i2c-${bus}/new_device"
    fi
done
