#!/bin/bash

LEASE=0
LEASES_FILE=`ps auxww | grep -- "-lf .*\.lease" | grep -v grep | grep -v sed | sed 's{^.*-lf \(.*\.lease\).*{\1{'`

logger -t $0 $LEASES_FILE" file will be used"
# Split file
rm -rf /tmp/lease*
while read line; do 
   if [[ $line =~ ^"lease {" ]]; then 
      LEASE=$(($LEASE+1))
   fi
   echo $line >> /tmp/lease$LEASE
done < $LEASES_FILE

# Remove not valid items
DATE=`date`
CUR=`date --date "$DATE" +%s`
for file in `ls /tmp/lease*`; do 
   DATE=`cat $file | grep expire | awk '{print $3" "$4}' | cut -f1 -d';'`
   REF=`date --date "$DATE" +%s`
   if [ $CUR -gt $REF ];
   then
      rm -rf $file
   else
      # Remove all others interfaces than eth0
      if [ `grep "interface \"eth0\"" $file | wc -l` -ne 1 ]; then
	 rm -rf $file
      fi
   fi	   
done

# Keep the last valid item 
NTP=""
if [ `ls /tmp/lease* | wc -l` -ge 1 ];
then
   FILE=`ls -tr /tmp/lease* | tail -1`
   STR=`grep ntp-servers  $FILE | cut -f1 -d";" | cut -c20-`
   NTP=`echo "${STR//\"}"`
fi

echo $NTP

