#! /bin/sh

TACB_BITSTREAM="/acterna/storage/fpga/u-boot-tacb.bin"

Interface=1
# Process arguments
if [ $# -eq 1 ]
then
    Interface="$1"
else
    echo "ERROR: No TACB selected"
    exit 1
fi

echo "TACB #${Interface}"

advisordff tacb -sf ${Interface} ${TACB_BITSTREAM}

case $? in
    0)
    # 0  = Flash success - We need to reboot
    exit 0
    ;;

    11)
    # 11 = Already up to date - There is nothing to be done
    exit 1
    ;;

    *)
    echo "ERROR: FPGA flash failed"
    exit 2
    ;;
esac
