#!/bin/sh
#
# This script initialize drivers related to 2k/4k modules as well as TACB for 6k/8k modules
#
#

PATH=$PATH:/usr/sbin/

# Get the i2c bus for optical port
nbus="i2c-2"
i2c_bus=$(i2cdetect -l | grep "$nbus-mux (chan_id 6" | awk '{print $1}')
#remove 'i2c-' string and send the number to the uts_scan driver
echo "${i2c_bus//i2c-}" > /tmp/i2c_optic_opt

isHetnetModuleUpdated[1]=-1
isHetnetModuleUpdated[2]=-1

# HETNET Modules Management
#
# Search for HETNET modules in position 1 or 2 and look for a TACB or a PUMA module
# For each module found, load it's overlay
for i in `seq 1 2`;
do
  response=$(qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords)
  if [[ "$response" =~ "703100B10-" ]]
  then
    echo "TACB found at address $i"

    # Program the TACB fpga if needed
    load_tacb_fpga.sh ${i}
    isHetnetModuleUpdated[$i]=$?

    # If the TACB has been updated, we can't handle the submodule behind it - We simply restart
    if [[ "${isHetnetModuleUpdated[$i]}" != "0" ]]
    then
        SYS_PLATFORM_DIR="/sys/platform_m$i"

        # Set all power
        echo "0xFFFFFFFF" > "${SYS_PLATFORM_DIR}/powersupply/all"

        sleep 0.1

        # Program "generic" fpga for the module under the TACB
        load_tacb_submodule_fpga.sh ${i}

        sleep 0.1
        # Select the module, module can be selected all the time in a TACB
        echo "0x00000081" > "${SYS_PLATFORM_DIR}/msel/register_msel"
        echo "0x000000A1" > "${SYS_PLATFORM_DIR}/msel/register_msel"
        echo "0x00000000" > "${SYS_PLATFORM_DIR}/msel/register_msel"
    fi
  elif [[ "$response" =~ "702200B64-" ]]
  then
    echo "PUMA module found at address $i"

    # Program the PUMA Module's fpga if needed
    load_puma_fpga.sh ${i}
    isHetnetModuleUpdated[$i]=$?
  fi
done

if   [[ "${isHetnetModuleUpdated[1]}" == "0" ]] \
  || [[ "${isHetnetModuleUpdated[2]}" == "0" ]]
then
  echo "A Hetnet module has been updated - Reboot in 5 seconds"

  # Simulate Otu launch to avoid rebooting in rescue mode
  otu_confirm_start.sh

  sleep 5

  reboot
  exit -1
fi

if [ -d "/sys/platform/uts_scan" ]
then
  #Launch rescan
  echo 1 > /sys/platform/uts_scan/rescan

  # Apply post op on fpga (programming the specific bitstream for the module under the TACB)
  for i in `seq 1 2`;
  do
    qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
    if [ $? -eq 0 ]
    then
      CFG_FILE=$(grep -E "^2[[:space:]]$((i - 1))" /sys/platform/uts_scan/modules | tr -s "\t" | cut -f6 | tr -d " ")
      if [ -n "$CFG_FILE" ]
      then
        SVF_FILE=/acterna/storage/fpga/"${CFG_FILE%.cfg}.svf"
        if [ -e "${SVF_FILE}" ]
        then
          load_tacb_submodule_fpga.sh ${i} "${SVF_FILE}"
          SYS_PLATFORM_DIR="/sys/platform_m${i}"
          sleep 0.1
          # Select the module, module can be selected all the time in a TACB
          echo "0x00000081" > "${SYS_PLATFORM_DIR}/msel/register_msel"
          echo "0x000000A1" > "${SYS_PLATFORM_DIR}/msel/register_msel"
          echo "0x00000000" > "${SYS_PLATFORM_DIR}/msel/register_msel"
        else
          echo "Specific bitstream not found, was searching for ${SVF_FILE}"
        fi
      fi
    fi
  done

  function export_gpio () {
    if [ ! -d "/sys/class/gpio/gpio$1" ]
    then
      echo $1 > /sys/class/gpio/export
    fi
  }

  BITSTREAM_FILE="/usr/share/firmware/amb_rev1_p0_proc.rbf.gz"
  XML_DESR="amb_rev1_p0_proc.rbf.advisor.xml.gz"
  export_gpio 9
  export_gpio 11
  export_gpio 67

  PROC_BOARD_ID2=$(cat /sys/class/gpio/gpio9/value)
  PROC_BOARD_ID1=$(cat /sys/class/gpio/gpio67/value)
  PROC_BOARD_ID0=$(cat /sys/class/gpio/gpio11/value)
  PROC_BOARD_ID=$(( $PROC_BOARD_ID0 + $PROC_BOARD_ID1 * 2 + $PROC_BOARD_ID2 * 4 ))

  if [ "$PROC_BOARD_ID" == "0" ]
  then
    BITSTREAM_FILE="/usr/share/firmware/amb_rev0_p0_proc.rbf.gz"
    XML_DESR="amb_rev0_p0_proc.rbf.advisor.xml.gz"
  fi

  SUCCEED="false"
  while [ "$SUCCEED" == "false" ]
  do
    hamma action.load.erase.xml.save verbose.2 slot.0 file./usr/share/firmware/${XML_DESR}
    if [ $? == 0 ]
    then
      SUCCEED="true"
    else
      sleep 1
    fi
  done
else
  exit 1
fi

exit 0
