#!/bin/sh
#
# This script de-initialize drivers related to 2k/4k module as well as tacb for 6k/8k modules
#

# TACB management
for i in `seq 1 2`;
do
  qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
  if [ $? -eq 0 ] ; then
    echo "TACB module found at module $i"

    # Stop the network interface
    ifconfig eth_M$i down

    # Reset all power
    # The sequence we follow is there to ensure the different voltages are shutdown in the correct order
    # The goal of this sequence is to avoid the bug with the U90 component on the 6k/8k modules
    # 1 - Cut off CLK80M
    echo "0xFFFCFFFF" > "/sys/platform_m$i/powersupply/all"
    # 2 - Shutdown every voltages but 3V3
    echo "0x00000008" > "/sys/platform_m$i/powersupply/all"
    # 3 - Shutdown 3V3
    echo "0x00000000" > "/sys/platform_m$i/powersupply/all"

    # Shutdown the Zynq
    echo "0" > "/sys/platform_m$i/zynq_hw_reset_n/value"
    # Waiting for the Zynq to take into account the reset signal
    sleep 4
  fi
done

exit 0
