#!/bin/bash

source /etc/otu_rfs_sync.conf # provide files to monitor

logfile=/var/log/otu_rfs_duplicate.log
DEST=/mnt/fs/unused_part

# $WATCHED_FILES_LIST
# $WATCHED_DIR_UPDATE_LIST

# Do not sync when duplicating
systemctl stop otu-rfs-sync.service

mount -o remount,rw $DEST

for file in $WATCHED_FILES_LIST; do
    RET="KO"
    rsync -a --delete $file $DEST/$file
    [[ $? -eq 0 ]] && RET="OK"
    echo "RFS: file = $file, duplication = $RET" >> $logfile
done

for dir in $WATCHED_DIR_UPDATE_LIST; do
    RET="KO"
    rsync -a --delete ${dir}/ $DEST/${dir}/
    [[ $? -eq 0 ]] && RET="OK"
    echo "RFS: dir = $dir, duplication = $RET" >> $logfile
done

mount -o remount,ro $DEST
