#!/bin/bash
#
# This script should be call by Otu when its start is completed
#
# It does the following :
#   - Reset the rescue mode : avoid falling in rescue_mode at next boot
#   - Check if both partitions have the same version, if not duplicate the current one
#

# fixup partition if there is any problem
mountpoint -q /cal && umount /cal
fsck.ext4 -y /dev/mmcblk0p2
mount /dev/mmcblk0p2 /cal

rm -f /cal/rescue_flag
# Remove some ext4 attribute annoying u-boot
dumpe2fs -h /dev/mmcblk0p2 2>/dev/null | grep metadata_csum -q
if [ $? -eq 0 ] ; then
  umount /cal
  e2fsck -f /dev/mmcblk0p2
  tune2fs -f -O ^metadata_csum,^64bit /dev/mmcblk0p2
  mount -o ro /dev/mmcblk0p2 /cal
fi
mount /cal -o remount,ro

# Find the current partition number
FILESYSTEM_BACKUP_IMG=/otu/release

# Get partition information
source /etc/otu/otuparts.sh

INSTALL_IMG_DIR=/otu/release/tmp/
LOGFILE=/var/log/otu_duplicate_$(date +%y-%m-%d-%H.%M.%S)

# Check if all information for duplication are available in a directory
function check_duplication_directory()
{
    if ! [ -d $1 ]
    then
        return -1
    fi
    for fp in core-image-jdsu-eotdrv2.tar.gz core-image-jdsu-eotdrv2.tar.gz.sig release.xml release.xml.sig
    do
        if ! [ -f ${1}/$fp ]
        then
            logger "Missing file for duplication $fp"
            return -1
        fi
    done
    return 0
}

# Duplicate current filesystem over alternative partition
function duplicate_current_filesystem ()
{
    nohup otu_duplicate_fs.sh ${INSTALL_IMG_DIR} > ${LOGFILE} 2>&1 &
}

#
# check for filesystem duplication
#
if [ -e $INSTALL_IMG_DIR/first_boot_after_upgrade.tmp ] && [ "$(cat $INSTALL_IMG_DIR/first_boot_after_upgrade.tmp)" == "$ALT_PART" ]
then
	duplicate_current_filesystem
fi

exit 0
