import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor
import "./UtilUiQt"

Rectangle {
    id: mainContainer

    width: 500
    height: 400

    border.width: 2
    border.color: VColor.cViaviColorGray
    color: VColor.cViaviColorWhite

    property int rowHeigth: 50

    function openKeyBoard(title, initialText) {
        keyboard.titleText = title;
        keyboard.initialText = initialText;

        keypad.visible = false;
        keyboard.visible = true;
    }

    function openKeyPad(title, initialText, dotAllowed, minValue, maxValue) {
        keypad.titleText = title
        keypad.initialText = initialText
        keypad.dotIsAllowed = dotAllowed

        keypad.minValue = minValue


        keypad.maxValue = maxValue
        keypad.configurableButtonPicturePath = ""

        keypad.visible = true;
        keyboard.visible = false;
    }
    
    Rectangle {
        id: title
        width: parent.width
        height: 30
        color: VColor.cViaviColorGray
        anchors.top : parent.top
        
        Text {
            id: titleTxt
            width: parent.width - 40
            height: parent.height
            
            anchors.left: parent.left
            anchors.leftMargin: 10

            wrapMode: Text.Wrap
            color: VColor.cViaviColorWhite
            text: wizardWindowManager_res_txtRecordingInformationTitle.value
            font.pixelSize: 20
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment:  Text.AlignVCenter
        }
     }
     
     Rectangle {
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.top: title.bottom
        anchors.topMargin: 10
        anchors.bottom: buttonSelection.top
        anchors.bottomMargin: 10
        
        clip: true
        
        color: "transparent"

        Flickable {
           id:idFickable
           anchors.fill: parent
           anchors.topMargin: 10
        
           enabled: !(keyboard.visible || keypad.visible )

           boundsBehavior: Flickable.StopAtBounds
        
           interactive: contentHeight >  height
           contentHeight: lineContainer.height
        
           Item {
               id: lineContainer

               height: columnContainer.height + 10
               width: parent.width - 20
                     
               Column {
                  id: columnContainer
                       
                  width: parent.width
                  
                  spacing: 0
                
                  Repeater {
                      id: choiceLine
                      model: wizardRecordingInformation_res_recordItemList.value
                      delegate: Wizard_Recording_Information_Item {}
                  }
               }
            }
         }
           //Rewind
            Triangle {
                id: canvas
                anchors.top:idFickable.top
                anchors.right: idFickable.right
                visible: !idFickable.atYBeginning
                height: parent.height * 0.06
                color_rectangle: VColor.cViaviColorWhite
                color_triangle: VColor.cViaviColorGray
                width: height
                sens:0
            }

            //Forward
            Triangle {
                id: canvasForward
                anchors.bottom: idFickable.bottom
                anchors.right:  idFickable.right
                height: parent.height * 0.06
                width: height
                visible: !idFickable.atYEnd
                color_rectangle: VColor.cViaviColorWhite
                color_triangle: VColor.cViaviColorGray
                sens:1
            }
    }

    Wizard_Recording_Information_Message_Box_Button {
        id: buttonSelection

        anchors.bottom: parent.bottom
        
        width: parent.width
        height: 70
        
        enabled: !(keyboard.visible || keypad.visible )
        validationIsPossible:  wizardRecordingInformation_res_isListValid.value
    }

    KeyboardUtils { id: keyboardUtils }

    WizardKeyboardAlpha {
        id: keyboard
        visible: false
        anchors.centerIn: parent
    }

    WizardKeyboardNumerical {
        id: keypad
        visible: false
        anchors.centerIn: parent
    }    
    
    Rectangle {
    		id: rectangle_disabled
            anchors.fill: parent
            color: VColor.cViaviColorGray
            opacity: 0.5
            visible: false
    }
}
