pragma Singleton
import QtQuick 2.5
import QtQml 2.0

Item {
    id: rootId

    readonly property ViaviColors colors: colorsId.item
    readonly property ViaviLayout layouts: layoutId.item
    readonly property ViaviImages images: imageId


    Component {
        id: viaviLayout
        ViaviLayout{
            id: viaviLayoutFile
            screenWidth: rootId.screenWidth
            screenHeight: rootId.screenHeight
        }
    }

    Component {
        id: viaviLayoutForSmallScreen
        ViaviLayoutForSmallScreen{
            id: viaviLayoutForSmallScreenFile
            screenWidth: rootId.screenWidth
            screenHeight: rootId.screenHeight
        }
    }

    Loader {
        id: layoutId
        sourceComponent: status_res_isSmallScreen.value ? viaviLayoutForSmallScreen : viaviLayout
    }


    //Colour themes
    Component {
        id: viaviColors
        ViaviColors {
            id: viaviColorsFile
        }
    }
    Component {
        id: viaviColorsContrastOutside
        ViaviColorsContrastOutside {
            id: viaviColorsContrastOutsideFile
        }
    }
    Component {
        id: viaviColorsSchemeDark
        ViaviColorsSchemeDark {
            id: viaviColorsSchemeDarkFile
        }
    }
    Component {
        id: viaviColorsSchemeSunshine
        ViaviColorsSchemeSunshine {
            id: viaviColorsSchemeSunshineFile
        }
    }

    function getColorScheme() {
        switch (misc_res_contrast.value) {
        case misc_res_contrast.enums.ecContrast_For_Indoor: {
            return viaviColors
        }
        case misc_res_contrast.enums.ecContrast_For_Outdoor: {
            return viaviColorsContrastOutside
        }
        case misc_res_contrast.enums.ecContrast_Scheme_Dark: {
            return viaviColorsSchemeDark
        }
        case misc_res_contrast.enums.ecContrast_Scheme_Sunshine: {
            return viaviColorsSchemeSunshine
        }
        default: {
            return viaviColors
        }
        }
    }

    Loader {
        id: colorsId
        sourceComponent: getColorScheme()
    }


    ViaviImages{
        id: imageId
    }

    property int screenWidth: platform.screenWidth
    property int screenHeight: platform.screenHeight

    //this should be added to a utils.js file
    function getValidDouble(input) {
        if(isNaN(input))
            return "--"
        else
            return input
    }

    property real waitingAnimationDuration: 3000
}
