import QtQuick 2.5
import "ViaviStyle"

Rectangle {

    readonly property int leftActiveState : 0
    readonly property int middleActiveState : 1
    readonly property int rightActiveState: 2
    property bool hasMiddleState: true

    property alias mouseArea: mouseArea
    property alias buttonState: draggableSwitch.buttonState
    property int toggleSize: 150

    property bool isLeftStateActive: buttonState === leftActiveState
    property bool isRightStateActive: buttonState === rightActiveState

    signal leftStateActive()
    signal middleStateActive()
    signal rightStateActive()

    width: toggleSize;
    height: width / 3

    radius: height / 2
    color: ViaviStyle.colors.activeColor
    border.color: ViaviStyle.colors.borderColor
    border.width: ViaviStyle.layouts.borderSmallWidth

    Rectangle {
        id: draggableSwitch

        property int buttonState: leftActiveState
        property double leftPos: horizontalMargins
        property double middlePos: parent.width/2 - width/2
        property double rightPos: parent.width - width - horizontalMargins
        property double horizontalMargins: parent.height * 0.2

        visible: true
        x: leftPos
        anchors.verticalCenter : parent.verticalCenter
        color: ViaviStyle.colors.contentBackgroundColor
        height: parent.height * 0.80
        width: height
        z:1
        radius:height / 2

        onButtonStateChanged: {
            x = getTargetPosFromState(buttonState)
            if (buttonState === leftActiveState) {
                leftStateActive()
            }
            else if (buttonState === middleActiveState) {
                middleStateActive()
            }
            else {
                rightStateActive()
            }
        }

        function getTargetStateFromDragPos() {
            var distLeft = Math.abs(x - leftPos)
            var distMiddle = hasMiddleState ? Math.abs(x - middlePos) : Number.POSITIVE_INFINITY
            var distRight = Math.abs(x - rightPos)
            var closestPos = Math.min(distLeft, distMiddle, distRight)
            if (closestPos === distLeft) {
                return leftActiveState
            }
            else if (closestPos === distMiddle) {
                return middleActiveState
            }
            else {
                return rightActiveState
            }
        }

        function getTargetPosFromState(state) {
            if (state === leftActiveState) {
                return leftPos
            }
            else if (state === middleActiveState) {
                return middlePos
            }
            else {
                return rightPos
            }
        }

        function chooseStateFromDragPos() {
            var state = getTargetStateFromDragPos()
            x = getTargetPosFromState(state)
            buttonState = state
        }
    }

    //A semi transparent switch, observable while dragging, to hint where the actuall switch will land when released.
    Rectangle {
        id: draggableSwitchGhost
        visible: mouseArea.drag.active
        opacity: 0.5
        x: draggableSwitch.getTargetPosFromState(draggableSwitch.getTargetStateFromDragPos())

        anchors.verticalCenter: parent.verticalCenter

        color: ViaviStyle.colors.contentBackgroundColor
        height: parent.height * 0.80
        width: height
        z:1
        radius: height / 2
    }

    function switchState() {
        if( buttonState === leftActiveState )
        {
            buttonState = hasMiddleState ? middleActiveState : rightActiveState
        }
        else if( buttonState === middleActiveState )
        {
            buttonState = rightActiveState
        }
        else if ( buttonState === rightActiveState )
        {
            buttonState = leftActiveState
        }
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        z:1
        visible: true
        enabled: true
        onClicked: switchState()
        drag.target: draggableSwitch
        drag.axis: Drag.XAndYAxis
        drag.minimumX: draggableSwitch.leftPos
        drag.maximumX: draggableSwitch.rightPos

        onReleased: {
            drag.target.chooseStateFromDragPos()
        }
    }
}
