import QtQuick 2.7
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.0

import "ViaviStyle"

Rectangle {
    id: rootItem

    readonly property font softkeysFont: ViaviStyle.layouts.isSmallScreen ?
                                             ViaviStyle.layouts.smallBoldFont : ViaviStyle.layouts.largeFont
    readonly property int softkeyHeight: height / 7
    function getSoftkeyYByIndex(index)
    {
        if(index > 0)
        {
            return rootItem.softkeyHeight * index
        }
        else
        {
            return 0
        }
    }

    function getSoftkeyBgColor(keyColor)
    {
        switch (keyColor) {
        case 0: return "#500778";
        case 1: return "#500778";
        case 2: return "#8451a0";
        case 3: return "#aeaeae";
        default: return "#ffffff";
        }
    }

    ListView {
        id: theListView
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        interactive: false
        focus: true
        clip: true
        keyNavigationWraps: true
        model: softkeys_res_softkeyData.value
        delegate: Rectangle {
            id: myDelegate
            
            width: parent.width
            height: rootItem.softkeyHeight
            
            color: getSoftkeyBgColor(keyColor)
            
            border.color : "#D8D8D8"
            border.width: 1
            
            enabled: keyColor !== 3 && keyColor !== 0
            
            Column {
                visible: (type == 1) && (keyColor !== 0)
                spacing: 1
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layouts.smallMargin
                anchors.bottom: parent.bottom
                anchors.bottomMargin: ViaviStyle.layouts.smallMargin
                width: parent.width

                Component {
                    id: c1Component
                    CheckBoxItem {
                        id:c1
                        text: label0
                        visible: (radio0 >= 4) && (radio0 <= 6)
                        checked: radio0 == 5
                        font: softkeysFont
                    }
                }
                Loader {
                    id: c1Loader
                    sourceComponent: c1Component
                    active: (radio0 >= 4) && (radio0 <= 6)
                    height: parent.height / 4 - 1
                }

                Component {
                    id: r1Component

                    RadioButtonItem {
                        id:r1
                        text: label0
                        visible: (radio0 >= 1) && (radio0 <= 3)
                        checked: radio0 == 2
                        font: softkeysFont
                    }
                }
                Loader {
                    id: r1Loader
                    sourceComponent: r1Component
                    active: (radio0 >= 1) && (radio0 <= 3)
                    height: parent.height / 4 - 1
                }

                Text { id: t0
                    text: label0
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    visible: (label0 !== "") && (radio0 >= 7) && (radio0 <= 12)
                    color: "white"
                    font: softkeysFont
                    leftPadding: ViaviStyle.layouts.smallMargin
                }

                Component {
                    id: c2Component
                    CheckBoxItem {
                        id:c2
                        text: label1
                        visible: (radio1 >= 4) && (radio1 <= 6)
                        checked: radio1 == 5
                        font: softkeysFont
                    }
                }
                Loader {
                    id: c2Loader
                    sourceComponent: c2Component
                    active: (radio1 >= 4) && (radio1 <= 6)
                    height: parent.height / 4 - 1
                }

                Component {
                    id: r2Component
                    RadioButtonItem {
                        id:r2
                        text: label1
                        visible: (radio1 >= 1) && (radio1 <= 3)
                        checked: radio1 == 2
                        font: softkeysFont
                    }
                }
                Loader {
                    id: r2Loader
                    sourceComponent: r2Component
                    active: (radio1 >= 1) && (radio1 <= 3)
                    height: parent.height / 4 - 1
                }

                Text { id: t1
                    text: label1
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    visible: (label1 !== "") && (radio1 >= 7) && (radio1 <= 12)
                    color: "white"
                    font: softkeysFont
                    leftPadding: ViaviStyle.layouts.smallMargin
                }

                Component {
                    id: c3Component
                    CheckBoxItem {
                        id:c3
                        visible: (radio2 >= 4) && (radio2 <= 6)
                        text: label2
                        checked: radio2 == 5
                        font: softkeysFont
                    }
                }
                Loader {
                    id: c3Loader
                    sourceComponent: c3Component
                    active: (radio2 >= 4) && (radio2 <= 6)
                    height : parent.height / 4 - 1
                }

                Component {
                    id: r3Component
                    RadioButtonItem {
                        id:r3
                        visible: (radio2 >= 1) && (radio2 <= 3)
                        text: label2
                        checked: radio2 == 2
                        font: softkeysFont
                    }
                }
                Loader {
                    id: r3Loader
                    sourceComponent: r3Component
                    active:(radio2 >= 1) && (radio2 <= 3)
                    height: parent.height / 4 - 1
                }

                Text { id: t2
                    text: label2
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    visible: (label2 !== "") && (radio2 >= 7) && (radio2 <= 12)
                    color: "white"
                    font: softkeysFont
                    leftPadding: ViaviStyle.layouts.smallMargin
                }

                Component {
                    id: c4Component
                    CheckBoxItem {
                        id:c4
                        text: label3
                        visible: (radio3 >= 4) && (radio3 <= 6)
                        checked: radio3 == 5
                        font: softkeysFont
                    }
                }
                Loader {
                    id: c4Loader
                    sourceComponent: c4Component
                    active: (radio3 >= 4) && (radio3 <= 6)
                    height: parent.height / 4 - 1
                }

                Component {
                    id: r4Component
                    RadioButtonItem {
                        id:r4
                        text: label3
                        visible: (radio3 >= 1) && (radio3 <= 3)
                        checked: radio3 == 2
                        font: softkeysFont
                    }
                }
                Loader {
                    id: r4Loader
                    sourceComponent: r4Component
                    active: (radio3 >= 1) && (radio3 <= 3)
                    height: parent.height / 4 - 1
                }

                Text { id: t3
                    text: label3
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    visible: (label3 !== "") && (radio3 >= 7) && (radio3 <= 12)
                    color: "white"
                    font: softkeysFont
                    leftPadding: ViaviStyle.layouts.smallMargin
                }
            }

            ColumnLayout{
                visible: (type == 0) && (keyColor !== 0)
                spacing: 1
                anchors.top:parent.top
                anchors.topMargin: 5
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 5
                width:parent.width
                Text { id: s0
                    text: label0
                    horizontalAlignment: Text.AlignHCenter
                    visible: label0 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }
                Text { id: s1
                    text: label1
                    horizontalAlignment: Text.AlignHCenter
                    visible: label1 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }
                Text { id: s2
                    text: label2
                    horizontalAlignment: Text.AlignHCenter
                    visible: label2 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }
                Text { id: s3
                    text: label3
                    horizontalAlignment: Text.AlignHCenter
                    visible: label3 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }

            }

            ColumnLayout{
                visible: (type == 2) && (keyColor !== 0)
                spacing: 1
                anchors.top:parent.top
                anchors.topMargin: 5
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 5
                width:parent.width
                Text { id: f0
                    text: label0
                    horizontalAlignment: Text.AlignHCenter
                    visible: label0 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }
                Text { id: f1
                    text: label1
                    horizontalAlignment: Text.AlignHCenter
                    visible: label1 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }
                Text { id: f2
                    text: label2
                    horizontalAlignment: Text.AlignHCenter
                    visible: label2 !== ""
                    color: "white"
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                    font: softkeysFont
                }

                Component {
                    id: f3Component
                    Image { id: f3
                        source: label3
                        visible: label3 !== ""
                        fillMode: Image.PreserveAspectFit
                    }
                }
                Loader {
                    id: f3Loader
                    sourceComponent: f3Component
                    active: label3 !== ""
                    Layout.maximumHeight: parent.height/3 - 1
                    Layout.alignment : Qt.AlignVCenter | Qt.AlignHCenter
                }

            }

            MouseArea {
                anchors.fill: parent
                z:1
                visible: true
                onClicked: {
                    softkeys_act_action.invokeWithStringArg(index)

                }
            }
        }
    }

}
