import QtQuick 2.3
import QtQuick.Layouts 1.3
import QtQuick.Controls 2.0
import "ViaviStyle"

FocusScope {
    id: rootId

    anchors.fill: parent

    function eventTypePopup(){
        if(eventscontrol_res_eventCodeVisible.value){
            return eventTypePopupId
        } else if ( eventRenamePopupId.isAvailable && schematicId.visible ) {
            return eventRenamePopupId
        }
        return null
    }

    readonly property int cNo_Table: 0
    readonly property int cSmall_Table: 1
    readonly property int cHalf_Table: 2
    readonly property int cHalf_Table_Cable: 3
    readonly property int cHalf_Table_Oeo_Process: 4
    readonly property int cFull_Table: 5
    readonly property int cFull_Table_For_Summary: 6
    readonly property int cFull_Table_And_Schematic: 7

    readonly property real scaleFactorMainTabRow: ViaviStyle.layouts.isSmallScreen ? 0.70 : 1.0

    // increase cell height only for Otdr, the other components would not benefit from this increase on small screens
    readonly property real scaleFactorTableDataCellHeight: ViaviStyle.layouts.isSmallScreen && status_res_otdrTabEnabled.value  ? 1.3 : 1.0

    property bool isGenericTableEnabled: status_res_tableMode.value !== cNo_Table &&
                                         !status_res_schematicEnabled.value &&
                                         !status_res_eventsTableEnabled.value &&
                                         !status_res_bargraphEnabled.value &&
                                         !status_res_tableNumericEnabled.value &&
                                         !status_res_realtimeNumericEnabled.value &&
                                         !status_res_analysisEnabled.value

    property int genericTableDefaultVisibleLines: 4
    property int genericTableDefaultHeight: (1 + 1 + genericTableDefaultVisibleLines) * ViaviStyle.layouts.genericTableLineHeight //title + header + actual lines

    Rectangle {
        id: contentRectId

        anchors.fill: parent

        color: ViaviStyle.colors.pageBackgroundColor

        EventTypePopup {
            id: eventTypePopupId
            overlayReplacer: getFiberMainPage()
        }

        EventRenamePopup{
            id: eventRenamePopupId
        }

        ColumnLayout {
            id: mainColumn

            anchors.left : parent.left
            anchors.right:parent.right
            anchors.leftMargin : ViaviStyle.layouts.largeMargin
            anchors.rightMargin : ViaviStyle.layouts.largeMargin

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.topMargin : ViaviStyle.layouts.mediumMargin
            anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

            spacing: ViaviStyle.layouts.mediumMargin

            Item {
                height: ViaviStyle.layouts.buttonHeight * rootId.scaleFactorMainTabRow - mainColumn.spacing
                Layout.fillWidth: true

                MainTabRow {
                    anchors.topMargin: - mainColumn.anchors.topMargin
                    anchors.bottomMargin: - mainColumn.spacing
                    anchors.fill: parent
                }

                visible: status_res_otdrTabEnabled.value
            }

            StackLayout {
                id: summaryView
                visible: status_cfg_miniSchematicVisible.value || status_cfg_summaryVisible.value
                            || ( !status_res_otdrTabEnabled.value && status_res_summaryEnabled.value )
                Layout.preferredHeight: summaryTrace.height
                Layout.maximumHeight: summaryTrace.height
                Layout.minimumHeight: summaryTrace.height
                Layout.fillWidth: true

                currentIndex: status_res_otdrTabEnabled.value && status_cfg_miniSchematicVisible.value ? 0 : 1
                MiniSlm {
                    id: summaryMiniSLM
                    Layout.fillWidth: true

                    selectedItemIndex: eventsTable.visible ? -1
                                        : trace.visible ? schematic_res_traceCursorSelectedItem.value
                                            : schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmEvent ? schematic_cfg_slmCurrentEvent.value : - 1

                    firstLastFromTrace: trace.visible ? true : false

                    firstItemDistance: eventsTable.visible ? eventsTable.firstItemDistance
                                                           : trace.visible ? trace.oXAxisVisibleLeft : schematicId.firstItemDistance
                    lastItemDistance: eventsTable.visible ? eventsTable.lastItemDistance
                                                          : trace.visible ? trace.oXAxisVisibleRight : schematicId.lastItemDistance
                }
                SummaryInfo {
                    id: summaryTrace
                    Layout.fillWidth: true
                }

            }

            Schematic {
                id: schematicId
                Layout.fillWidth: true

                height: ViaviStyle.layouts.schematicHeight
                visible: status_res_schematicEnabled.value
                         && !status_res_traceEnabled.value

                eventPopup: eventTypePopup()
            }

            Item {
                id: smarkLinkSummary
                Layout.fillWidth: true
                Layout.fillHeight: true

                visible: !status_res_traceEnabled.value
                         && (status_res_tableMode.value !== cFull_Table)
                         && !status_res_fullGraph.value

                /* add Bargraph component */
                Bargraph {

                    anchors.fill: parent

                    visible: status_res_bargraphEnabled.value
                }

                Fiber{
                    anchors.fill: parent

                    visible: !status_res_eventDetailEnabled.value
                             && !status_res_bargraphEnabled.value
                }

                Loader {
                    anchors.fill: parent

                    visible: status_res_eventDetailEnabled.value
                             && !status_res_bargraphEnabled.value
                    source: ViaviStyle.layouts.isSmallScreen ?
                                "EventInfoOptimeterLayout.qml" : "EventInfo.qml"
                }
            }

            Events{
                id: eventsTable
                Layout.fillWidth: true
                Layout.fillHeight: true

                visible: !status_res_traceEnabled.value
                         && status_res_eventsTableEnabled.value
                         && !status_res_bargraphEnabled.value

                eventPopup: eventTypePopup()
            }

            Item {
                id: splitView
                visible: status_res_traceEnabled.value || isGenericTableEnabled

                Layout.fillHeight: true
                Layout.fillWidth: true

                Trace {
                    id: trace

                    visible: status_res_traceEnabled.value

                    anchors.left : parent.left
                    anchors.right : parent.right
                    anchors.top: parent.top
                    anchors.bottom: separator.visible ? separator.top : parent.bottom

                    focus: true

                    onZoomLevelChanged: {
                        summaryTrace.setTraceZoomLevel(xScale, yScale, wScale, hScale)
                    }
                    onVisibleChanged: {
                        if (visible) {
                            forceActiveFocus()
                        }
                    }
                }

                //not the most elegant solution. an improvement could be possible with taking into acount the following aspects
                //1 - there should be the posibility for full screen trace or full screen table (ex: CD files, there is full screen table)
                //a - in case of full screen the separtor should disapear and the item should fill the Item containing them
                //b - switching between full screen and trace+table view should preserve the size of the table/trace
                //2 - switching between diffrent function tabs should consistent
                //a - if both tabs have the same size (otdr has diffrent size than osa because slm/trace/table tabs) the trace/table size should preserve
                //b - if the tabs don't have the same size the current implementation will preserve the size of the smallest item (trace or table)
                property bool sizesInitialized: false
                property int prevHeight

                function tryInitializeSplitterPosition(){
                    if(!sizesInitialized
                            && separator.visible){
                        sizesInitialized = true
                        separator.y = height - genericTableDefaultHeight
                    }
                }

                onHeightChanged: {
                    if(!sizesInitialized){
                        splitView.tryInitializeSplitterPosition()
                    }else {
                        var prevTraceHeight = separator.y
                        var prevTableHeight = prevHeight - separator.y - separator.height
                        if (prevTraceHeight > prevTableHeight){
                            separator.y = height - prevTableHeight - separator.height
                        } else {
                            separator.y = prevTraceHeight
                        }
                        var maxHeight = splitView.height - genericTable.titleAreaHeight - separator.height //mouseArea.drag.maximumY, which is not yet propagated at this point
                        if (separator.y > maxHeight) {
                            separator.y = maxHeight
                        }
                    }
                    prevHeight = height
                }

                Item {
                    id: separator
                    anchors.horizontalCenter: parent.horizontalCenter

                    width: ViaviStyle.layouts.dragableSeparatorWidth
                    height: ViaviStyle.layouts.mediumMargin


                    property alias pressed: mouseArea.pressed

                    visible: trace.visible && genericTable.visible

                    Rectangle {
                        //Note: a white backgroud is required for this image, otherwise the lines of items bellow it can be seen through the transparent triangles creating a dizzy effect
                        id: dragIndicatorParent
                        anchors.bottom: parent.bottom
                        width: ViaviStyle.layouts.dragableSeparatorWidth
                        height: 4*ViaviStyle.layouts.smallMargin
                        color: 'white'
                        FiberColorImage {
                            id: dragIndicator
                            source: ViaviStyle.images.dragVerticalImg
                            anchors.fill: parent
                            color: separator.pressed ? ViaviStyle.colors.selectedColor: ViaviStyle.colors.activeColor
                        }
                    }

                    MouseArea {
                        id: mouseArea
                        anchors.fill: parent
                        anchors.topMargin: parent.height - dragIndicatorParent.height - ViaviStyle.layouts.mediumMargin
                        anchors.bottomMargin: -genericTable.titleCellHeight
                        height: ViaviStyle.layouts.buttonHeight

                        drag.axis: Drag.YAxis
                        drag.target: separator
                        drag.maximumY: splitView.height - genericTable.titleAreaHeight - separator.height
                        drag.minimumY: ViaviStyle.layouts.buttonHeight
                    }
                }


                GenericTable {
                    id: genericTable

                    visible: isGenericTableEnabled
                    anchors.left : parent.left
                    anchors.right : parent.right
                    anchors.top: separator.visible ? separator.bottom : parent.top
                    anchors.bottom: parent.bottom

                    titleCellHeight: (buttonsRow.width > 0 && generictable_res_genericTableNbLineUpperTable.value < 2)
                                     ? ViaviStyle.layouts.imageButtonHeight + 2 * ViaviStyle.layouts.smallMargin
                                     : ViaviStyle.layouts.genericTableLineHeight
                    dataCellHeight: ViaviStyle.layouts.genericTableLineHeight * rootId.scaleFactorTableDataCellHeight

                    onVisibleChanged: {
                        splitView.tryInitializeSplitterPosition()
                    }

                    Row{
                        id: buttonsRow

                        anchors.right: parent.right
                        anchors.rightMargin: ViaviStyle.layouts.smallMargin
                        anchors.top: parent.top
                        anchors.topMargin: ViaviStyle.layouts.smallMargin
                        spacing: ViaviStyle.layouts.veryLargeMargin

                        FiberImageButton{
                            visible: misc_res_addEventState.value !== misc_res_addEventState.enums.ecKey_Color_Invisible

                            enabled: misc_res_addEventState.value !== misc_res_addEventState.enums.ecKey_Color_Grey
                            anchors.top: parent.top
                            anchors.topMargin: ViaviStyle.layouts.smallMargin

                            source: ViaviStyle.images.eventIcon

                            onClicked:{
                                misc_act_addEvent.invoke()
                            }
                        }

                        FiberImageButton{
                            id: lockMeasButton

                            visible: misc_res_measLockButtonState.value !== misc_res_measLockButtonState.enums.ecKey_Color_Invisible
                            enabled: misc_res_measLockButtonState.value !== misc_res_measLockButtonState.enums.ecKey_Color_Grey
                            checked: misc_res_measLocked.value

                            source: checked ? ViaviStyle.images.pinLockedIcon : ViaviStyle.images.pinUnlockedIcon

                            onClicked: {
                                misc_act_measLockAction.invoke()
                            }
                        }

                        FiberImageButton{
                            id: autoMeasButton

                            visible: misc_res_autoMeasButtonState.value !== misc_res_autoMeasButtonState.enums.ecKey_Color_Invisible
                            enabled: misc_res_autoMeasButtonState.value !== misc_res_autoMeasButtonState.enums.ecKey_Color_Grey

                            source: ViaviStyle.images.reloadIcon

                            onClicked: {
                                misc_act_autoMeas.invoke()
                            }
                        }
                    }

                    titleBackgroundColor: separator.pressed
                                          ? ViaviStyle.colors.secondaryInfoColor
                                          : ViaviStyle.colors.borderColor
                }
            }


            /* add Bargraph component */
            Bargraph {
                id: bargraph2
                Layout.fillWidth: true
                visible: status_res_bargraphEnabled.value && (status_res_traceEnabled.value || status_res_eventsTableEnabled.value) &&
                         !status_res_tableNumericEnabled.value && !status_res_realtimeNumericEnabled.value
            }

            NumericDisplay {
                id: tableNumeric
                infoType: 'Table'
                Layout.fillWidth: true
                visible: status_res_tableNumericEnabled.value
            }

            RealtimeNumericDisplay {
                id: realtimeNumeric
                Layout.fillWidth: true
                visible: status_res_realtimeNumericEnabled.value
            }

            Analysis {
                id: analysis
                Layout.fillWidth: true
                visible: status_res_analysisEnabled.value && status_res_traceEnabled.value
            }
        }
    }
}
