import QtQuick 2.7
import "ViaviStyle"

Column{

    id: firstColumn1

    property int maxComponentsWidth: Math.max(laserId.width, value1Id.width, value2Id.width)

    property alias value1Text: value1Id.text
    property alias value2Text: value2Id.text
    property alias laserText: laserId.text

    property color value1Color
    property color value2Color

    property bool isCaptionColumn

    topPadding: ViaviStyle.layouts.mediumMargin
    bottomPadding: ViaviStyle.layouts.mediumMargin

    spacing: ViaviStyle.layouts.smallMargin

    Text{
        id: laserId
        anchors.right: parent.right

        height: contentHeight + ViaviStyle.layouts.mediumMargin
        width: contentWidth

        color: ViaviStyle.colors.secondaryInfoColor
        font : ViaviStyle.layouts.headerFont
        visible: text
    }

    Text{
        id: value1Id

        anchors.left: isCaptionColumn ? parent.left : undefined
        anchors.right: isCaptionColumn ? undefined : parent.right

        height: ViaviStyle.layouts.tableFontMetrics.height
        width: contentWidth

        color: isCaptionColumn ? ViaviStyle.colors.secondaryInfoColor : value1Color
        font: isCaptionColumn ? ViaviStyle.layouts.headerFont : ViaviStyle.layouts.tableFont
    }

    Text{
        id: value2Id

        anchors.left: isCaptionColumn ? parent.left : undefined
        anchors.right: isCaptionColumn ? undefined : parent.right

        height: ViaviStyle.layouts.tableFontMetrics.height
        width: contentWidth

        color: isCaptionColumn ? ViaviStyle.colors.secondaryInfoColor : value2Color
        font: isCaptionColumn ? ViaviStyle.layouts.headerFont : ViaviStyle.layouts.tableFont
    }
}
