﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import "ViaviStyle"

RowLayout {
    id: rootId

    spacing: ViaviStyle.layouts.isSmallScreen ?
                 ViaviStyle.layouts.veryLargeMargin * 2 : ViaviStyle.layouts.veryLargeMargin

    property font tabsFont: ViaviStyle.layouts.largeFont
    property font tabsBoldFont: ViaviStyle.layouts.largeBoldFont

    CheckTextButton{
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true

        checked: !status_res_traceEnabled.value
                 && !status_res_eventsTableEnabled.value
                 && !status_res_otdrCableCoEnabled.value

        text: schematic_res_viewLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            status_act_switchToSLM.invoke()
        }
    }

    CheckTextButton {
        id: traceTabButton
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true
        checked: status_res_traceEnabled.value

        text: trace_res_viewLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            status_act_switchToTrace.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_eventsTableEnabled.value
        enabled: status_res_resultsTableAvailable.value

        text: events_res_viewLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            status_act_switchToTable.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_otdrCableCoEnabled.value
        enabled: cable_res_viewButtonEnabled.value && !status_res_otdrCableCoEnabled.value

        text: cable_res_viewButtonLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            status_act_switchToCable.invoke()
        }

        visible: cable_res_viewButtonEnabled.value
    }

    Item {
        id: spacer
        Layout.fillWidth: true
    }

    ThreeStateButtonOption {
        id: threeStateButton

        visible: !status_res_otdrCableCoEnabled.value
        hasMiddleState: traceTabButton.checked

        Layout.fillHeight: true

        leftText: schematic_res_miniSLMLabel.value
        rightText: trace_res_miniTraceLabel.value

        button.onLeftStateActive:
        {
            status_cfg_miniSchematicVisible.value = true
            status_cfg_summaryVisible.value = false
        }

        button.onMiddleStateActive:
        {
            status_cfg_summaryVisible.value = false
            status_cfg_miniSchematicVisible.value = false
        }
        button.onRightStateActive:
        {
            status_cfg_miniSchematicVisible.value = false
            status_cfg_summaryVisible.value = true
        }
    }
}
