import QtQuick 2.3
import QtQuick.Layouts 1.1
import "ViaviStyle"
import "./UtilUiQt"

FocusScope {
    anchors.fill: parent

    default property alias mainAreaData: mainArea.data
    property alias fileExplorerDetailsData: fileExplorerDetailsContainer.data
    property alias fullScreenData: fullScreenContainer.data

    function dialogIconPath()
    {
        switch(dialog_res_iconType.value){
        case dialog_res_iconType.enums.ecW_Stop:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Stop.png"
        case dialog_res_iconType.enums.ecW_Warn:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Warning.png"
        case dialog_res_iconType.enums.ecW_Error:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Error.png"
        case dialog_res_iconType.enums.ecW_Info:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Info.png"
        case dialog_res_iconType.enums.ecW_Comms:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Comms.png"
        case dialog_res_iconType.enums.ecW_Pass:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Pass.png"
        case dialog_res_iconType.enums.ecW_Fail:
            return ViaviStyle.images.iconsCustomIsuPath + "Dialog_Icon_Fail.png"
        default:
            return ""
        }
    }

    Rectangle {
        id: root
        anchors.fill: parent

        color: "white"

        RowLayout{
            anchors.fill: parent

            spacing: 0

            Item {

                Item{
                    id: mainArea

                    anchors.fill: parent
                }

                Layout.fillHeight: true
                Layout.fillWidth: true

                FiberSetup {
                    width: parent.width
                    height: parent.height

                    visible: menu_res_visible.value
                    firstMenuYAlign: softkeys.getSoftkeyYByIndex(menu_res_alignToSoftkeyIndex.value)
                }

                ColumnLayout{

                    visible: filebrowser_res_visible.value

                    anchors.fill: parent

                    Column{
                        id: fileExplorerDetailsContainer

                        Layout.fillWidth: true
                    }

                    File_Explorer {
                        Layout.fillHeight: true
                        Layout.fillWidth: true
                        focus: true

                        visible: filebrowser_res_visible.value
                    }
                }

            }

            Softkeys{
                id: softkeys
                Layout.fillHeight: true

                width: ViaviStyle.layouts.softKeysWidth

            }
        }

        Item{
            id: fullScreenContainer

            anchors.fill: parent
        }

        Keyboard {
            visible: keyboard_res_enabled.value
        }

        Dialog{

            visible: dialog_res_enabled.value

            titleText: dialog_res_idText.value
            text: dialog_res_mainText.value
            exitText:  dialog_res_exitText.value
            iconSource: dialogIconPath()
            button1Text: dialog_res_button1Text.value
            button2Text: dialog_res_button2Text.value
            deaf: dialog_res_deaf.value
            dialogType: dialog_res_type.value

            onButton1Action: {
                dialog_act_button1Action.invoke()
            }

            onButton2Action: {
                dialog_act_button2Action.invoke()
            }

            onUserActionClose: {
                dialog_act_userCloseAction.invoke()
            }
        }
    }
}
