import QtQuick 2.5
import "ViaviStyle"

QtObject {

    readonly property int nrOfRows: 5
    readonly property int nrOfNumericColumns: 3
    readonly property real nrOfAlphaVisualColumns: 12

    /* alpha button dimensions */
    readonly property int buttonWidthAlphaKeyb: computeMaxButtonWidthAlphaKeyb()
    readonly property int buttonHeightAlphaKeyb: ViaviStyle.layouts.keyboardButtonHeight
    readonly property int buttonWidthCustom: buttonWidthAlphaKeyb * 1.5

    /* Numeric keyboard definition */
    readonly property int widthNumericKeyb: ViaviStyle.layouts.keyboardNumericButtonWidth * nrOfNumericColumns + buttonWidthCustom + 3 * keyboardHorizontalMargin //left/right margin + margin between custom button an others
    readonly property int heightNumericKeyb: buttonHeightAlphaKeyb * nrOfRows + heightKeyboardHeader + 3 * keyboardVerticalMargin
    readonly property int xNumericKeyb: (ViaviStyle.layouts.screenWidth - widthNumericKeyb) / 2
    readonly property int yNumericKeyb: (ViaviStyle.layouts.screenHeight - heightNumericKeyb) / 2

    /* Alphanumeric keyboard definition */
    readonly property int widthAlphaKeyb: computeWidthAlphaKeyb(buttonWidthAlphaKeyb)
    readonly property int heightAlphaKeyb: buttonHeightAlphaKeyb * nrOfRows + heightKeyboardHeader + 3 * keyboardVerticalMargin
    readonly property int xAlphaKeyb: (ViaviStyle.layouts.screenWidth - widthAlphaKeyb) / 2
    readonly property int yAlphaKeyb: (ViaviStyle.layouts.screenHeight - heightAlphaKeyb) / 3

    //Compute width for the alphanumeric keyboard for a given button width
    //Derived from the formula: buttonWidthAlphaKeyb * nrOfAlphaVisualColumns + buttonWidthCustom + 3 * keyboardHorizontalMargin //left/right margin + margin between custom button an others
    function computeWidthAlphaKeyb(buttonWidth) {
        return buttonWidth * (nrOfAlphaVisualColumns + 1.5) + 3 * keyboardHorizontalMargin
    }

    //Compute maximum width of a button in the alphanumeric keyboard. On small screens the entire screen area is used, on large ones the ViaviLayout dimensions are used.
    function computeMaxButtonWidthAlphaKeyb() {
        var res = ViaviStyle.layouts.keyboardAlphaButtonWidth
        if (computeWidthAlphaKeyb(res) > ViaviStyle.layouts.screenWidth) {
            res = (ViaviStyle.layouts.screenWidth - 3 * keyboardHorizontalMargin) / (nrOfAlphaVisualColumns + 1.5)
        }
        return res
    }

    /* margins */
    readonly property int keyboardHorizontalMargin: ViaviStyle.layouts.largeMargin
    readonly property int keyboardVerticalMargin: ViaviStyle.layouts.mediumMargin

    /* keyboard header = text field + title */
    readonly property int heightKeyboardText: ViaviStyle.layouts.keyboardTextFontMetrics.height + 2 * ViaviStyle.layouts.mediumMargin
    readonly property int heightKeyboardTitle: 2 * ViaviStyle.layouts.titleTextFontMetrics.height
    readonly property int spacingKeyboardHeader: ViaviStyle.layouts.smallMargin
    readonly property int heightKeyboardHeader: heightKeyboardText + heightKeyboardTitle + spacingKeyboardHeader


    /* common panels sizes */
    readonly property int widthRightColumn: buttonWidthCustom + ViaviStyle.layouts.mediumMargin
    readonly property int heightBottomRow: buttonHeightAlphaKeyb

    /* button types */
    readonly property int buttonTypeNumerical: 0
    readonly property int buttonTypeAlpha: 1
    readonly property int buttonTypeCustom: 2
    readonly property int buttonType2ndPage: 3

    readonly property string buttonIconPath: "/acterna/storage/look-and-feel/generic/"

    readonly property int buttonWidthNumericKeyb: ( widthNumericKeyb - 2 * keyboardHorizontalMargin ) / 4.5
    readonly property int buttonHeightNumericKeyb: ( heightNumericKeyb - heightKeyboardHeader - 3 * keyboardVerticalMargin ) / 5
    readonly property int buttonSpacing: ViaviStyle.layouts.smallMargin
}
