import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQml 2.2
import "ViaviStyle"
import 'layouts'
import 'ViaviVirtualKeyboard'

Rectangle {

    id: keyboard

    width: keyboardUtils.widthAlphaKeyb
    height: keyboardUtils.heightAlphaKeyb

    x: keyboardUtils.xAlphaKeyb
    y: keyboardUtils.yAlphaKeyb

    color: ViaviStyle.colors.alternativeBackgroundColor

    property alias configurableButtonPicturePath: commonKeys.configurableButtonPicturePath
    property alias hasDefaultButton: commonKeys.hasDefaultButton
    property alias initialText: keyboardText.initialText
    property alias textField: keyboardText.textField
    property alias titleDescription: keyboardText.titleDescription
    property alias titleText: keyboardText.titleText
    property alias hasTitleAction: keyboardText.hasTitleAction
    property alias inputTextMaxLength: keyboardText.inputTextMaxLength
    property alias secondPageKeysModel: secondPageId.keysModel

    signal titleClicked()
    signal canceled()
    signal accepted()
    signal configurableButtonClicked()
    signal inputTextChanged(string newText)
    signal defaultPressed()

    property bool secondPageOn: false
    property bool hasSecondPage: secondPageKeysModel ? secondPageKeysModel.count > 0 : false

    property bool fullLevel1: true
    property bool fullLevel2: true

    property string systemLanguage: "en_EN"

    function updateInputContexFullLevelsFlags(){
        if(keyboard.visible){
            InputContext.fullLevel1 = keyboard.fullLevel1
            InputContext.fullLevel2 = keyboard.fullLevel2
        }
    }

    onVisibleChanged: updateInputContexFullLevelsFlags()
    onFullLevel1Changed: updateInputContexFullLevelsFlags()
    onFullLevel2Changed: updateInputContexFullLevelsFlags()
    Component.onCompleted: updateInputContexFullLevelsFlags()

    function customButtonClicked( button )
    {
        switch ( button )
        {
        case "Enter":
            keyboard.accepted()
            break
        case "Cancel":
            keyboard.canceled()
            break;
        case "Caps":
            InputContext.capsLock = !InputContext.capsLock
            break
        case "Default":
            keyboard.defaultPressed()
            break
        case "Back":
            /* he have to make sure we also delete the predefined labels [] */
            var endPos = keyboardText.cursorPos - 1
            var startPos = endPos

            if ( keyboardText.textField[ endPos ] === "]" )
            {
                while(true){
                    startPos--

                    if(startPos < 0){
                        startPos = endPos
                        break
                    }

                    if(keyboardText.textField[ startPos ] === "[" ){
                        break
                    }

                    if(keyboardText.textField[ startPos ] === "]"){
                        startPos = endPos
                        break
                    }


                }
            }

            keyboardText.textField = keyboardText.textField.substring ( 0, startPos ) +
                    keyboardText.textField.substring( endPos + 1, keyboardText.textField.length )

            keyboardText.cursorPos = startPos
            break
        case "Clear":
            keyboardText.textField = ""
            break
        case "LeftArrow":
            /* skipping predefined lables [], if any */
            var pos = keyboardText.cursorPos - 1

            if ( keyboardText.textField[ pos ] === "]" )
            {
                while( keyboardText.textField[ pos ] !== "[" )
                    pos--
            }

            keyboardText.cursorPos = pos
            break
        case "RightArrow":
            /* skipping predefined labels [], if any */
            var pos = keyboardText.cursorPos

            if ( keyboardText.textField[ pos ] === "[" )
            {
                while( keyboardText.textField[ pos ] !== "]" )
                    pos++
            }

            keyboardText.cursorPos = pos + 1
            break
        case "[auto]":
        case "[AUTO]":
        case "abc":
            secondPageOn = !secondPageOn
            break
        case 'ShowLayouts':
            layoutChooser.open()
            break
        default:
            break
        }
    }

    /* alphanumerical character clicked, we add it in the current position */
    function charButtonClicked( button )
    {
        var pos = keyboardText.cursorPos
        keyboardText.textField = keyboardText.textField.substring ( 0, pos ) + button +
                keyboardText.textField.substring( pos, keyboardText.textField.length )
        keyboardText.cursorPos = pos + 1
    }

    function extraButtonClicked( button )
    {
        var pos = keyboardText.cursorPos
        keyboardText.textField = keyboardText.textField.substring ( 0, pos ) +
                "["+ button +"]"+
                keyboardText.textField.substring( pos, keyboardText.textField.length )
        keyboardText.cursorPos = pos + button.length + 2
    }

    onHasSecondPageChanged: {
        if(!hasSecondPage){
            secondPageOn = false
        }
    }

    KeyboardHeader { 
        id: keyboardText

        onTitleClicked: keyboard.titleClicked()
        onInputTextChanged: keyboard.inputTextChanged(newText)
        onInputTextAccepted: keyboard.accepted()
    }

    Item {
        id: keyboardAlphaKeys

        anchors.top: keyboardText.bottom
        anchors.topMargin: keyboardUtils.keyboardVerticalMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: keyboardUtils.keyboardVerticalMargin
        anchors.right: parent.right
        anchors.rightMargin: keyboardUtils.keyboardHorizontalMargin
        anchors.left: parent.left
        anchors.leftMargin: keyboardUtils.keyboardHorizontalMargin

        LocaleLayoutLoader {
            id: localisedLayout
            //Just initialisation, not binding, as it observes both keyboard_cfg_keyboardLayout.valueString and the layouts menu:
            //https://www.kdab.com/new-qt-5-10-diagnostics-breaking-qml-bindings/
            layoutName: keyboard.systemLanguage
            visible: !secondPageOn

            Connections {
                target: keyboard
                onSystemLanguageChanged: {
                    if (localisedLayout.getLayoutPath(localisedLayout.layoutName)) {
                        localisedLayout.layoutName = keyboard.systemLanguage
                    }
                }
            }
        }

        Keyboard2ndPageKeys {
            id: secondPageId
            visible:  keyboard.hasSecondPage && secondPageOn
        }

        KeyboardAlphaCommonRow {
            id: keyboardAlphaCommonRow
            secondPageOn: keyboard.secondPageOn
            hasSecondPage: keyboard.hasSecondPage
        }

        KeyboardCommonKeys {
            id:commonKeys
        }
    }

    FiberMenu {
        id: layoutChooser
        visible: false

        Component.onCompleted: {
            var globalPos = keyboardAlphaCommonRow.layoutSwitchButton.mapToItem(keyboard, 0, 0)
            x = globalPos.x
            y = globalPos.y
        }

        fiberModel: localisedLayout.layouts
        fiberDelegate: FiberMenuItem {
                       text: displayName
                       onTriggered: {
                           localisedLayout.layoutName = name
                           layoutChooser.close()
                       }
                       activeHighlight: localisedLayout.layoutName === model.name
                   }
        }
}



