import QtQuick 2.3
import QtQuick.Layouts 1.2

import "ViaviStyle"

Item {
    id: root
    property int cellWidth: 0
    property string textColor: "red"
    property string textDisplay: ""
    property bool isIcon: false
    property bool isSelected: false
    property bool isHeader: false
    property font cellFont: ViaviStyle.layouts.tableFont
    property bool isNote: false
    property int textAlignment: generictable_res_textAlignment.enums.ecLeft_Format
    property bool isIconManual: false
    property string emptyCellText: "--"

    clip: false
    width: cellWidth
    height: ViaviStyle.layouts.genericTableLineHeight

    function getTextAlignment( elementAlignment )
    {
        switch( elementAlignment ){
        case generictable_res_textAlignment.enums.ecCenter_Format:
            return Text.AlignHCenter
        case generictable_res_textAlignment.enums.ecLeft_Format:
            return Text.AlignLeft
        case generictable_res_textAlignment.enums.ecRight_Format:
            return Text.AlignRight
        }
        return Text.AlignLeft;
    }

    Text {
        id: valueTextId
        visible: !isIcon
        anchors.fill: parent

        horizontalAlignment: getTextAlignment( root.textAlignment )
        verticalAlignment: Text.AlignVCenter
        color: root.textDisplay.trim() === ""
                ? (isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor)
                   : root.textColor
        font: root.cellFont
        text: root.isHeader || root.isNote ? root.textDisplay : (root.textDisplay.trim() === "" ? emptyCellText : root.textDisplay)
    }

    Component {
        id: imageComponent
        Rectangle {
            anchors.fill: parent
            color: isSelected ? ViaviStyle.colors.activeColor: ViaviStyle.colors.activeItemTextColor

            FiberColorImage {
                id: eventIcon

                anchors.fill: parent
                anchors.margins: ViaviStyle.layouts.isSmallScreen ? ViaviStyle.layouts.mediumMargin / 2 : 0

                source: root.isIcon ? root.textDisplay : ""
                fillMode: Image.PreserveAspectFit
                smooth: true

                color:  root.isSelected ?  ViaviStyle.colors.activeItemTextColor : "transparent"
            }

            // * for manually modified event codes
            Text {
                visible: isIconManual

                anchors.bottom: parent.bottom
                anchors.bottomMargin: -ViaviStyle.layouts.cursorInfoFontMetrics.height * 0.4
                anchors.left: parent.left

                color: isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
                font: ViaviStyle.layouts.cursorInfoFont
                text: "*"
            }
        }
    }

    Loader {
        id: iconLoader
        sourceComponent: imageComponent
        active: isIcon

        anchors.fill: parent
    }
}
