import QtQuick 2.3
import QtQuick.Layouts 1.1
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id:root

    property Item localDevice: null
    property Item remoteDevice: null
    property alias leftConnectorSource: leftConnector.source
    property alias rightConnectorSource: rightConnector.source
    property alias middleFiberSource: middleFiber.source
    property alias leftLineSource: leftLine.source
    property alias rightLineSource: rightLine.source
    property alias quarterFiberLeftSource: quarterFiberLeft.source
    property alias quarterFiberRightSource: quarterFiberRight.source
    property alias loopback1StFiber: loopback1StFiberNumber.text
    property alias loopback2NdFiber: loopback2NdFiberNumber.text

    function getStateName() {
            switch(synoptic_res_linkState.value){
            case synoptic_res_linkState.enums.elsConnected:
                return connectedState
            case synoptic_res_linkState.enums.elsLoopback:
                return loopbackState
            case synoptic_res_linkState.enums.elsLoopback_AB:
                return loopbackABState
            case synoptic_res_linkState.enums.elsLoopback_BA:
                return loopbackBAState
            case synoptic_res_linkState.enums.elsTerminator:
                return terminatorState
            case synoptic_res_linkState.enums.elsJumper:
                return jumperState
        }

        return noLinkState
    }

    readonly property string connectedState: "connectedState"
    readonly property string loopbackState: "loopbackState"
    readonly property string loopbackABState: "loopbackABState"
    readonly property string loopbackBAState: "loopbackBAState"
    readonly property string terminatorState: "terminatorState"
    readonly property string jumperState: "jumperState"
    readonly property string noLinkState: "noLinkState"


    state: getStateName()

    function getConnectorImage(elfEnum){
        switch(elfEnum.value){
        case elfEnum.enums.ecsOTDRPass:
            return ViaviStyle.images.fixRefIconPass
        case elfEnum.enums.ecsOTDRFail:
            return ViaviStyle.images.fixRefIconFail
        }

        return ""
    }

    height: leftConnector.height

    Image{
        id: leftConnector

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.left
    }

    Image{
        id: rightConnector

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.right
    }

    Text {
        id: loopback1StFiberNumber

        anchors.right: quarterFiberLeft.left
        anchors.rightMargin: ViaviStyle.layouts.mediumMargin
        anchors.bottom: quarterFiberLeft.top
        // using negative margins since the icon has a lot of blank space on top
        // and there is no other space available for this label
        anchors.bottomMargin: -quarterFiberLeft.height * 0.4

        font: ViaviStyle.layouts.activeTextFont
        color: ViaviStyle.colors.mainInfoColor
        z: quarterFiberLeft.z + 1
    }

    Text {
        id: loopback2NdFiberNumber

        anchors.right: quarterFiberLeft.left
        anchors.rightMargin: ViaviStyle.layouts.mediumMargin
        anchors.top: quarterFiberLeft.bottom
        anchors.topMargin: ViaviStyle.layouts.smallMargin

        font: ViaviStyle.layouts.activeTextFont
        color: ViaviStyle.colors.mainInfoColor
        z: quarterFiberLeft.z + 1
    }

    Image{
        id: middleFiber

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: leftConnector.top

        x: rightConnector.source.toString().length === 0
              ? parent.width - width
              : parent.width / 2 - width / 2
    }

    Image{
        id: leftLine

        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: leftConnector.top
        anchors.left: leftConnector.right
        anchors.right: middleFiber.left
    }

    Image{
        id: quarterFiberLeft

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: leftLine.top
        anchors.horizontalCenter: leftLine.horizontalCenter
    }

    Image{
        id: rightLine

        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: middleFiber.top
        anchors.left: middleFiber.right
        anchors.right: rightConnector.left
    }

    Image{
        id: quarterFiberRight

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: rightLine.top
        anchors.horizontalCenter: rightLine.horizontalCenter
    }

    Image{
        id: firstConnectorState

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: leftConnector.top
        anchors.horizontalCenter: leftConnector.horizontalCenter

        source: getConnectorImage(synoptic_res_firstConnectionState)
    }

    Image{
        id: middleConnectorState

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        anchors.top: middleFiber.top
        anchors.horizontalCenter: middleFiber.horizontalCenter

        source: getConnectorImage(synoptic_res_middleConnectionState)
    }


    states: [
        State {
            name: connectedState
            PropertyChanges { target: root; visible: true
                                            width: remoteDevice.connectorX - localDevice.connectorX
                                            x: localDevice.connectorX;
                                            y: localDevice.connectorY - height;
                                            leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorLaunch
                                            rightConnectorSource: ViaviStyle.images.fixLinkRightConnectorLaunch
                                            middleFiberSource: ViaviStyle.images.fixLinkFiberMiddle
                                            leftLineSource: ViaviStyle.images.fixLinkFiberLine
                                            rightLineSource: ViaviStyle.images.fixLinkFiberLine
                                            quarterFiberLeftSource: ""
                                            quarterFiberRightSource: ""
                                            loopback1StFiber: ""
                                            loopback2NdFiber: ""
                                            }
        },
        State {
            name: loopbackState
            PropertyChanges { target: root; visible: true
                                            leftConnectorSource: ViaviStyle.images.fixLinkLeftConnector
                                            rightConnectorSource: ViaviStyle.images.fixLinkRightConnector
                                            middleFiberSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            leftLineSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            rightLineSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            width: localDevice.width / 3;
                                            x: localDevice.connectorX - width / 2;
                                            y: localDevice.connectorY - height;
                                            quarterFiberLeftSource: ""
                                            quarterFiberRightSource: ""
                                            loopback1StFiber: ""
                                            loopback2NdFiber: ""
                                            }
        },
        State {
            name: loopbackABState
            PropertyChanges { target: root;     visible: true
                                                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                                                x: localDevice.connectorX;
                                                y: localDevice.connectorY - height;
                                                leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorLoopAB
                                                rightConnectorSource: ""
                                                middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleLoopABBA
                                                leftLineSource: ViaviStyle.images.fixLinkFiberLineLoopABBA
                                                rightLineSource: ""
                                                quarterFiberLeftSource: ViaviStyle.images.fixLinkFiberQuarterFiberLoopABBA
                                                quarterFiberRightSource: ""
                                                loopback1StFiber: synoptic_res_loopback1StFiberNumber.value
                                                loopback2NdFiber: synoptic_res_loopback2NdFiberNumber.value
                                                    }
        },
        State {
            name: loopbackBAState
            PropertyChanges { target: root; visible: true
                                            width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                                            x: localDevice.connectorX;
                                            y: localDevice.connectorY - height;
                                            leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorLoopBA
                                            rightConnectorSource: ""
                                            middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleLoopABBA
                                            leftLineSource: ViaviStyle.images.fixLinkFiberLineLoopABBA
                                            rightLineSource: ""
                                            quarterFiberLeftSource: ViaviStyle.images.fixLinkFiberQuarterFiberLoopABBA
                                            quarterFiberRightSource: ""
                                            loopback1StFiber: synoptic_res_loopback1StFiberNumber.value
                                            loopback2NdFiber: synoptic_res_loopback2NdFiberNumber.value
                                            }
        },
        State {
            name: terminatorState
            PropertyChanges { target: root; visible: true
                                            width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                                            x: localDevice.connectorX;
                                            y: localDevice.connectorY - height;
                                            leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorSimpleLaunch
                                            rightConnectorSource: ""
                                            middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleTerminator
                                            leftLineSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            rightLineSource: ""
                                            quarterFiberLeftSource: ViaviStyle.images.fixLinkFiberMiddleLaunch
                                            quarterFiberRightSource: ""
                                            loopback1StFiber: ""
                                            loopback2NdFiber: ""
                                            }
        },
        State {
            name: jumperState
            PropertyChanges { target: root; visible: true
                                            width: remoteDevice.connectorX - localDevice.connectorX
                                            x: localDevice.connectorX;
                                            y: localDevice.connectorY - height;
                                            leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorSimpleLaunch
                                            rightConnectorSource: ViaviStyle.images.fixLinkRightConnectorSimpleLaunch
                                            middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleJumper
                                            leftLineSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            rightLineSource: ViaviStyle.images.fixLinkFiberLineLaunch
                                            quarterFiberLeftSource: ViaviStyle.images.fixLinkFiberMiddleLaunch
                                            quarterFiberRightSource: ViaviStyle.images.fixLinkFiberMiddleLaunch
                                            loopback1StFiber: ""
                                            loopback2NdFiber: ""
                                            }
        },
        State {
            name: noLinkState
            PropertyChanges { target: root; visible: false}
        }
    ]
}
