import QtQuick 2.3
import QtQuick.Layouts 1.1
import elf_plugin 1.0

import "ViaviStyle"


Item {
    id: root
    property ElfData deviceState;
    property ElfData deviceType;
    property ElfData functionState;

    property int connectorX
    property int connectorY

    property int connectorYOffset: 0



    function updateConnectorXLocation(){
        connectorX = x + width / 2
    }

    function updateConnectorYLocation(){
        connectorY = y + connectorYOffset
    }

    function updateLocationXFromConnector(){
        x = connectorX - width / 2
    }

    function updateLocationYFromConnector(){
        y = connectorY - connectorYOffset
    }

    onXChanged: updateConnectorXLocation()
    onYChanged: updateConnectorYLocation()
    onWidthChanged: updateConnectorXLocation()
    onHeightChanged: updateConnectorYLocation()

    onConnectorXChanged: updateLocationXFromConnector()
    onConnectorYChanged: updateLocationYFromConnector()

    property alias deviceImageOpacity: deviceImage.opacity


    function getStateName()
    {
        if(deviceState){
            switch(deviceState.value){
            case deviceState.enums.edsLocal:
                return localState
            case deviceState.enums.edsRemote:
                return remoteState
            case deviceState.enums.edsRemoteNoLink:
                return remoteNoLinkState
            }
        }

        return notPresentState
    }

    width: deviceImage.width
    height: deviceImage.height

    Image{
        id: deviceImage
        
        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale
        source: getDeviceImagePath()
    }

    state: getStateName()

    readonly property string localState: "Local"
    readonly property string remoteState: "Remote"
    readonly property string remoteNoLinkState: "RemoteNoLink"
    readonly property string notPresentState: "NotPresent"

    function getFunctionStateImage(){
        switch(functionState.value){
        case functionState.enums.efsWait:
            return ViaviStyle.images.fixFunctionWait;
        case functionState.enums.efsNoDataLink:
            return ViaviStyle.images.fixFunctionNoDataLink;
        case functionState.enums.efsDataLink:
            return ViaviStyle.images.fixFunctionDataLink;
        case functionState.enums.efsM2MLinkOn:
            return ViaviStyle.images.fixFunctionM2MLinkOn;
        case functionState.enums.efsM2MLinkOff:
            return ViaviStyle.images.fixFunctionM2MLinkOff;
        case functionState.enums.efsPow:
            return ViaviStyle.images.fixFunctionPow;
        case functionState.enums.efsSrc:
            return ViaviStyle.images.fixFunctionSrc;
        case functionState.enums.efsOTDR:
            return ViaviStyle.images.fixFunctionOTDR;
        case functionState.enums.efsORL:
            return ViaviStyle.images.fixFunctionORL;
        case functionState.enums.efsFaultFinder:
            return ViaviStyle.images.fixFunctionFaultFinder;
        case functionState.enums.efsReceive:
            return ViaviStyle.images.fixFunctionReceive;
        case functionState.enums.efsSend:
            return ViaviStyle.images.fixFunctionSend;
        case functionState.enums.efsOEO:
            return ViaviStyle.images.fixFunctionOEO;
        case functionState.enums.efsFiberLength:
            return ViaviStyle.images.fixFunctionFiberLenth;
        }

        return ViaviStyle.images.fixFunctionNoFunction;
    }

    Image{
        anchors.fill: parent

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layouts.fixImageScale
        height: sourceSize.height * ViaviStyle.layouts.fixImageScale

        source: getFunctionStateImage()
    }

    function getDeviceImagePath() {
        //Compose a device name

        var deviceImagePath = ViaviStyle.images.iconsPath + 'fcomp/fix_syn_device_'
        var typeStr = ''
        if (deviceType) {
            switch (deviceType.value) {
            case deviceType.enums.edtSmartOTDR:
            case deviceType.enums.edt2000:
                typeStr = '2000'
                break
            case deviceType.enums.edt4000:
                typeStr = '4000'
                break
            case deviceType.enums.edt5800:
                typeStr = '5800'
                break
            case deviceType.enums.edtONA_800:
                typeStr = 'ONA-800'
                break
            case deviceType.enums.edtONA_1000:
                typeStr = 'ONA-1000'
                break
            default:
                typeStr = 'ONA-800'
                break;
            }
        }
        deviceImagePath += typeStr;

        if(deviceState){
            switch(deviceState.value){
            case deviceState.enums.edsLocal:
                deviceImagePath += '.png'
                break
            case deviceState.enums.edsRemote:
                deviceImagePath += '_remote.png'
                break
            case deviceState.enums.edsNotPresent:
                deviceImagePath = ViaviStyle.images.fixDeviceNotPresentImage
                break
            case deviceState.enums.edsRemoteNoLink:
                deviceImagePath += '_remote.png'
                break
            default:
                deviceImagePath += '.png'
                break
            }
        }
        return deviceImagePath
    }

    states: [
        State {
            name: localState
            PropertyChanges { target: root; deviceImageOpacity: 1.0}
        },
        State {
            name: remoteState
            PropertyChanges { target: root; deviceImageOpacity: 1.0 }
        },
        State {
            name: remoteNoLinkState
            PropertyChanges { target: root; deviceImageOpacity: 0.3;}
        },
        State {
            name: notPresentState
            PropertyChanges { target: root; deviceImageOpacity: 1.0 }
        }
    ]
}

