import QtQuick 2.5
import QtQuick.Layouts 1.1
import QtQuick.Window 2.2
import "ViaviStyle"

MainPage {
    id: fiberMainPage

    readonly property real scaleFactor: ViaviStyle.layouts.isSmallScreen ? 0.70 : 1

    anchors.fill: parent
    
    function getFiberMainPage() {
        return fiberMainPage
    }

    Shortcut {
        sequence: 'Ctrl+S'
        onActivated: {
            hardkeys_act_onStartStopButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+F'
        onActivated: {
            hardkeys_act_onFileButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+U'
        onActivated: {
            hardkeys_act_onSetupButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+W'
        onActivated: hardkeys_act_onMTSOptionButton.invoke()
    }

    Shortcut {
        sequence: 'Esc'
        onActivated: hardkeys_act_onCancelButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+R'
        onActivated: hardkeys_act_onResultsButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+H'
        onActivated: hardkeys_act_onHomeButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+P'
        onActivated: hardkeys_act_onPrintButton.invoke()
    }
    signal topLevelUpPressed()
    signal topLevelDowPressed()
    signal topLevelLeftPressed()
    signal topLevelRightPressed()
    signal topLevelReturnPressed()
    Keys.onUpPressed: {
        console.log('FiberMainPage - unfocused up caught!')
        topLevelUpPressed()
    }
    Keys.onDownPressed: {
        console.log('FiberMainPage - unfocused down caught!')
        topLevelDowPressed()
    }
    Keys.onLeftPressed: {
        console.log('FiberMainPage - unfocused left caught!')
        topLevelLeftPressed()
    }
    Keys.onRightPressed: {
        console.log('FiberMainPage - unfocused right caught!')
        topLevelRightPressed()
    }
    Keys.onReturnPressed: {
        console.log('FiberMainPage - unfocused return caught!')
        topLevelReturnPressed()
    }
    


    //the forceRefresh is need on mts5800 because window doesn't redraw by itself.
    property bool ignoreRefreshAfterResize: false
    function forceRefresh(){
        if(ignoreRefreshAfterResize){
            ignoreRefreshAfterResize = false
        } else {
            fiberMainPage.visible = false
            refreshTimer.restart()
        }
    }

    Connections{
        target: status_res_refreshMainViewFlag
        onValueChanged: {
            forceRefresh()
        }
    }

    onWidthChanged: ignoreRefreshAfterResize = true
    onHeightChanged: ignoreRefreshAfterResize = true
    
    Timer{
        id: refreshTimer
        interval: 10
        onTriggered: fiberMainPage.visible = true
    }
    

    FocusScope {
        id: contentFocusScope
        width: parent.width
        anchors.top: parent.top
        anchors.bottom: tabsItem.visible ? tabsItem.top: parent.bottom

        Loader {
            id: scopeMain
            source: 'ScopeMain.qml'
            anchors.fill: parent
            active: status_res_scopeEnabled.value
            visible: active
            focus: true
        }

        Loader {
            source: 'LTSMain.qml'
            anchors.fill: parent
            active: status_res_sourceNumericEnabled.value || status_res_powermeterNumericEnabled.value
            visible: active
        }

        Loader {
            id: fcompMain
            source: 'FCompMain.qml'
            anchors.fill: parent
            active: status_res_fcompEnabled.value
            visible: active
        }

        Loader {
            source: "Pow_Pon.qml"
            anchors.fill: parent
            active: status_res_powWindowEnabled.value
            visible: active
        }

        Rectangle {
            visible: status_res_otdrCableCoEnabled.value
            anchors.fill: parent
            color: ViaviStyle.colors.pageBackgroundColor

            ColumnLayout {
                id: otdrCableColumn

                anchors.left : parent.left
                anchors.right:parent.right
                anchors.leftMargin : ViaviStyle.layouts.largeMargin
                anchors.rightMargin : ViaviStyle.layouts.largeMargin

                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.topMargin : ViaviStyle.layouts.mediumMargin
                anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

                spacing: ViaviStyle.layouts.mediumMargin

                Item {
                    height: ViaviStyle.layouts.buttonHeight * fiberMainPage.scaleFactor - otdrCableColumn.spacing
                    Layout.fillWidth: true

                    MainTabRow {
                        anchors.topMargin: - otdrCableColumn.anchors.topMargin
                        anchors.bottomMargin: - otdrCableColumn.spacing
                        anchors.fill: parent
                    }
                }

                FiberContainer {
                    Layout.fillWidth: true
                    Layout.fillHeight:  true

                    Loader{
                        anchors.fill: parent
                        source: status_res_cableCoState.value
                        visible: status_res_otdrCableCoEnabled.value
                        active: status_res_otdrCableCoEnabled.value
                    }
                }
            }
        }

        Rectangle {
            visible: status_res_fixCableCoEnabled.value
            anchors.fill: parent
            color: ViaviStyle.colors.pageBackgroundColor

            ColumnLayout {
                id: fcompCableColumn

                anchors.left : parent.left
                anchors.right:parent.right
                anchors.leftMargin : ViaviStyle.layouts.largeMargin
                anchors.rightMargin : ViaviStyle.layouts.largeMargin

                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.topMargin : ViaviStyle.layouts.mediumMargin
                anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

                spacing: ViaviStyle.layouts.mediumMargin

                Item {
                    height: ViaviStyle.layouts.buttonHeight * fiberMainPage.scaleFactor - fcompCableColumn.spacing
                    Layout.fillWidth: true

                    FCompTabRow {
                        anchors.topMargin: - fcompCableColumn.anchors.topMargin
                        anchors.bottomMargin: - fcompCableColumn.spacing
                        anchors.fill: parent
                    }
                }

                FiberContainer {
                    Layout.fillWidth: true
                    Layout.fillHeight:  true

                    Loader{
                        anchors.fill: parent
                        source: status_res_cableCoState.value
                        visible: status_res_fixCableCoEnabled.value
                        active: status_res_fixCableCoEnabled.value
                    }
                }
            }
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_cfg_batteryModeEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_cfg_batteryModeEnabled.value

            anchors.fill: parent

            source: "DTSBatteryView.qml"
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_cfg_heatMapEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_cfg_heatMapEnabled.value

            anchors.fill: parent

            source: "DTSHeatMapView.qml"
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_res_batterySetupEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_res_batterySetupEnabled.value
            anchors.fill: parent

            source: "DTSBatterySetup.qml"
        }
    }

    FunctionsTabs{
        id: tabsItem

        visible: status_res_functionsTabsEnabled.value
        width: parent.width
        anchors.bottom: parent.bottom
    }

    DebugInfo{
        id: debugInfoItem

        visible: status_res_debugInfoEnabled.value
        width: parent.width
        anchors.bottom: parent.bottom
    }

    fileExplorerDetailsData: SummaryInfo {
        visible: status_res_fileSummaryEnabled.value
        width: parent.width
    }

    fullScreenData: Item{
        anchors.fill: parent

        OsaGrid{
            visible: status_res_osaGridEnabled.value
        }

        DwdmGrid{
            visible: status_res_dwdmGridEnabled.value
        }

        PibGrid{
            visible: status_res_pibGridEnabled.value
        }

        WdmTable{
            visible: status_res_wdmTableEnabled.value
        }

        FixMessagePopup {
            visible: status_res_fixMessagePopupEnabled.value
        }

        FCompProjectSetup {
            visible: !filebrowser_res_visible.value && fcompMain.visible && fcompProject_cfg_setupEnabled.value
        }

        Loader{
            /* Wizard PopUp shown at the end of each measurement */
            source: "PopUp_Box.qml"
            anchors.bottom: parent.bottom
            anchors.bottomMargin: status_res_functionsTabsEnabled.value ? tabsItem.height : 0 + ViaviStyle.layouts.largeMargin
            anchors.horizontalCenter: parent.horizontalCenter

            width: parent.width * 0.6
            height: parent.height * 0.45

            visible: status_res_popUpBoxEnabled.value
            active: status_res_popUpBoxEnabled.value
        }

        MouseArea{
            enabled: wizardLoader.active
            //make sure mouse events are not send to items in the background

            anchors.fill: parent

            Loader{
                id: wizardLoader

                /* Wizard component */
                source: status_res_wizardState.value
                visible: status_res_wizardEnabled.value
                active:status_res_wizardEnabled.value
                anchors.fill: parent
            }
        }
    }
}
