import QtQuick 2.5
import QtQuick.Controls 2.0
import "ViaviStyle"

Popup{

    id: root

    property alias model: listView.model
    property alias delegate: listView.delegate
    property int currentIndex: listView.currentIndex
    property alias titleText: titleTextId.text

    signal cancelClicked()
    signal validateClicked()

    width: parent.width
    height: parent.height
    x: 0
    y: 0

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }

    contentItem: Item {

        anchors.fill: parent

        FiberContainer {
            id: mainContainer
            width: ViaviStyle.layouts.smallPopupWidth
            height: Math.min(parent.height,
                             titleBox.height + buttonBox.height
                             + 2 * ViaviStyle.layouts.smallMargin
                             + listView.count * ViaviStyle.layouts.buttonHeight)


            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter

            FiberContainer {
                id: titleBox

                property int noOfTextRows: Math.ceil( ViaviStyle.layouts.titleTextFontMetrics.advanceWidth( titleTextId.text ) / width )

                width: parent.width
                height: Math.max ( noOfTextRows * ( ViaviStyle.layouts.titleTextFontMetrics.height + ViaviStyle.layouts.mediumMargin )
                                   + 2 * ViaviStyle.layouts.smallMargin, ViaviStyle.layouts.buttonHeight + 2 * ViaviStyle.layouts.smallMargin )
                anchors.top: parent.top

                Text {
                    id: titleTextId
                    anchors.centerIn: parent

                    width: parent.width

                    font: ViaviStyle.layouts.titleTextFont
                    color: ViaviStyle.colors.mainInfoColor

                    horizontalAlignment: Text.AlignHCenter
                    wrapMode: Text.WordWrap
                }
            }

            Item {
                id: listContainer

                anchors.top: titleBox.bottom
                anchors.bottom: buttonBox.top
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.margins: ViaviStyle.layouts.smallMargin

                clip:true

                ListView {
                    id: listView

                    currentIndex: root.currentIndex


                    anchors.fill: parent

                    boundsBehavior: Flickable.StopAtBounds

                    highlightFollowsCurrentItem: true
                    highlightMoveVelocity: -1
                    highlightMoveDuration: -1

                    snapMode: ListView.SnapToItem

                    ScrollBar.vertical: ScrollBar {
                        id: listScrollBar
                        width: ViaviStyle.layouts.mediumMargin
                        contentItem: Rectangle {
                            radius: ViaviStyle.layouts.smallMargin
                            color: ViaviStyle.colors.borderColor
                        }

                        visible: listView.contentHeight > listView.height
                    }

                    onVisibleChanged: {
                        if( visible )
                        {
                            listView.currentIndex = root.currentIndex
                            listView.positionViewAtIndex( listView.currentIndex , ListView.Center )
                        }
                    }
                }
            }

            FiberContainer{
                id: buttonBox

                width: parent.width
                height: ViaviStyle.layouts.buttonHeight + 2 * ViaviStyle.layouts.smallMargin

                anchors.bottom: parent.bottom

                FiberImageButton {
                    id: cancelButton

                    anchors.left: parent.left
                    anchors.leftMargin: parent.width * 0.25
                    anchors.verticalCenter: parent.verticalCenter

                    source: ViaviStyle.images.sourceDwdmCancelBtnImg

                    onClicked: root.cancelClicked()
                }

                FiberImageButton{
                    id: enterButton

                    anchors.right: parent.right
                    anchors.rightMargin: parent.width * 0.25
                    anchors.verticalCenter: parent.verticalCenter

                    source: ViaviStyle.images.sourceDwdmEnterBtnImg

                    onClicked: root.validateClicked()
                }
            }
        }
    }
}
