import QtQuick 2.5
import QtQuick.Layouts 1.3
import QtQuick.Controls 2.0
import "ViaviStyle"

//TODO: cleanly merge with FiberListDelegate
Rectangle {
    id: root

    property bool isSelected
    property alias text: textId.text
    property string iconPath: ''
    signal clicked()

    height: ViaviStyle.layouts.buttonHeight

    anchors.left: parent.left
    anchors.right: parent.right

    color: isSelected ? ViaviStyle.colors.activeColor: ViaviStyle.colors.contentBackgroundColor

    FiberColorImage {
        id: icon
        visible: iconPath.length > 0
        width: visible ? parent.height : 0
        fillMode: Image.PreserveAspectFit
        source: iconPath
        mipmap: true
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: centerMarker.left
        color:  isSelected ?  ViaviStyle.colors.activeItemTextColor : "transparent"
    }

    Item {
        id: centerMarker
        width: ViaviStyle.layouts.largeMargin
        anchors.centerIn: parent
    }

    Text {
        id: textId
        font: ViaviStyle.layouts.activeBoldTextFont
        color: isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: centerMarker.right
    }


    MouseArea {
        anchors.fill: parent
        onClicked: {
            root.clicked()
        }
    }
}
