import QtQuick 2.3
import QtQuick.Layouts 1.2

import "ViaviStyle"

FiberContainer{
    id : root
    ColumnLayout{
        id: columnId
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        property real passCellWidth: ViaviStyle.layouts.veryLargeMargin
        property real cellWidth : (width - passCellWidth) / 4

        TableHeaderRow{
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_laserLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_lossLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_orlLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_attenuationLabel.value
            }
            TableHeaderCell{
                width: columnId.passCellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                //valueText: "P/F"
                valueText: fibers_res_passLabel.value
            }
        }

        ListView {
            id: theListView

            Layout.fillHeight : true
            Layout.fillWidth: true

            boundsBehavior: Flickable.OvershootBounds
            clip: true
            model: fibers_res_fibersData.value

            delegate: TableRow {
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: laser
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: loss
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: orl
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: attenuation
                }
                Image {
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom
                    width: columnId.passCellWidth

                    fillMode: Image.PreserveAspectFit
                    source: pass
                }
            }
        }
    }
}

