import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import "ViaviStyle"

RowLayout {
    id: rootId

    spacing: ViaviStyle.layouts.isSmallScreen ?
                     ViaviStyle.layouts.veryLargeMargin * 2 : ViaviStyle.layouts.veryLargeMargin

    property font tabsFont: ViaviStyle.layouts.largeFont
    property font tabsBoldFont: ViaviStyle.layouts.largeBoldFont

    CheckTextButton{
        Layout.fillHeight: true

        checked: fcomp_res_view.value === fcomp_res_view.enums.efvProc
                 && !status_res_fixCableCoEnabled.value

        text: fcomp_res_procLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
               {
               fcomp_act_switchToProc.invoke();
               }
        }
    }

    //CableCo button
    CheckTextButton{
        Layout.fillHeight: true

        visible: cable_res_viewButtonEnabled.value
        checked: status_res_fixCableCoEnabled.value
        enabled: cable_res_viewButtonEnabled.value

        text: fcomp_res_cableCoLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
            {
                fcomp_act_switchToCableCo.invoke()
            }
        }
    }

    //CableTable button
    CheckTextButton{
        Layout.fillHeight: true
        
        visible: fcomp_res_cableTableButtonVisible.value && !cable_res_viewButtonEnabled.value
        checked: fcomp_res_view.value === fcomp_res_view.enums.efvCableTable
        enabled: fcomp_res_cableTableButtonEnabled.value

        onVisibleChanged: {
            if(!visible && checked){
                fcomp_act_switchToProc.invoke();
            }
        }

        text: fcomp_res_cableTableLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
               {
               fcomp_act_switchToCableTable.invoke();
               }
        }
    }

    // IL-ORL
    CheckTextButton{
        Layout.fillHeight: true

        checked: fcomp_res_view.value === fcomp_res_view.enums.efvIlOrl && !status_res_fixCableCoEnabled.value
        enabled: fcomp_res_tableButtonEnabled.value

        text: fcomp_res_summaryLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
               {
               fcomp_act_switchToIlOrl.invoke();
               }
        }
    }

	// SmartLink
    CheckTextButton{
        Layout.fillHeight: true

        enabled: fcomp_res_smartlinkButtonEnabled.value
        visible: fcomp_res_smartlinkButtonVisible.value
        checked: fcomp_res_view.value === fcomp_res_view.enums.efvSmartLink && !status_res_fixCableCoEnabled.value

        text: fcomp_res_smartlinkLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
               {
               fcomp_act_switchToSmartLink.invoke();
               }
        }
    }

    // Fault Finder
    CheckTextButton{
        id: faultFinderBtn

        Layout.fillHeight: true
        
        visible: fcomp_res_faultFinderButtonVisible.value
        enabled: fcomp_res_faultFinderButtonEnabled.value
        checked: fcomp_res_view.value === fcomp_res_view.enums.efvFaultFinder

        text: fcomp_res_faultFinderLabel.value
        font: checked ? tabsBoldFont: tabsFont

        mouseArea.onClicked: {
            if ( !checked )
               {
               fcomp_act_switchToFaultFinder.invoke()
               }
        }
    }

    Item {
        id: spacer
        Layout.fillWidth: true
    }

    ToggleButtonOption {
        id: toggle

        visible: fcomp_res_isLoopbackToggleEnabled.value
        Layout.fillWidth: true

        leftText:  fcomp_res_firstFiberLabel.value
        rightText: fcomp_res_secondFiberLabel.value
        onToggledChanged: {
            fcomp_cfg_selectedFiber.value = toggled
        }
    }
}
