import QtQuick 2.7
import elf_plugin 1.0
import base_plugin 1.0
import QtQuick.Layouts 1.2
import "ViaviStyle"
FiberContainer {
    id: rootItem

    readonly property real scaleFactor: ViaviStyle.layouts.isSmallScreen ? 0.7 : 1
    property int alarm: events_res_alarm.value

    property FiberPopup eventPopup

    property double firstItemDistance
    property double lastItemDistance

    function getTableText(value){
        if(value === ""){
            return "--"
        }
        return value
    }

    function getTextColor(alarm, text){
        if(text === ""){
            return ViaviStyle.colors.mainInfoColor
        }else{
            return ViaviStyle.colors.getTextColor(alarm)
        }
    }

    Item{
        anchors.fill:parent
        anchors.margins: ViaviStyle.layouts.borderSize

        ToggleButtonOption {
            id: tButton
            height: ViaviStyle.layouts.buttonHeight
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.verticalCenter: headerRow.verticalCenter

            leftText: events_res_allLabel.value
            rightText: events_res_failedLabel.value
        }

        Component{
            id: headerText

            Text{
                id: laserTextId

                height: contentHeight
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignRight

                color: ViaviStyle.colors.secondaryInfoColor
                font : ViaviStyle.layouts.headerFont

                text: laserName
            }
        }

        Row{
            id: headerRow

            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layouts.largeMargin * rootItem.scaleFactor
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            height: Math.max( laserId0.height + ViaviStyle.layouts.mediumMargin, tButton.height )
            spacing: ViaviStyle.layouts.largeMargin * rootItem.scaleFactor

            Loader{
                id: laserId0

                property string laserName: events_res_laserLabel0.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId1

                property string laserName: events_res_laserLabel1.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId2

                property string laserName: events_res_laserLabel2.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId3

                property string laserName: events_res_laserLabel3.value
                visible: laserName

                sourceComponent: headerText
            }
        }

        ListView {
            id: theListView
            boundsBehavior: Flickable.OvershootBounds
            anchors.top: headerRow.bottom
            anchors.bottom: parent.bottom

            anchors.left: parent.left
            anchors.right: parent.right

            focus: true
            clip: true
            currentIndex: events_res_traceCurrentEventIndex.value
            keyNavigationWraps: true
            model: events_res_eventsData.value

            property bool isListCompleted: false

            function updateFirstLastEvent(){
                var startItem = theListView.itemAt(theListView.width * 0.5, theListView.contentY )
                if(startItem){
                    if(startItem.modelIndex === 0 && theListView.contentY === startItem.y ){
                    	//the events table doesn't have the first element in the minislm. if at the top use the saved value
                        rootItem.firstItemDistance = schematic_res_firstEntryPosition.value
                    } else {
                        rootItem.firstItemDistance = startItem.distance
                    }
                }else{
                    rootItem.firstItemDistance = 0
                }

                var endItem = theListView.itemAt(theListView.width * 0.5, Math.min(theListView.contentY + theListView.height - 1
                                               ,theListView.contentY + theListView.contentHeight -1));

                if(endItem){
                    rootItem.lastItemDistance = endItem.distance
                }
            }

            Component.onCompleted: {
                theListView.isListCompleted = true
                updateFirstLastEvent()

            }

            onContentYChanged: {
                if ( theListView.isListCompleted === true) {
                    theListView.updateFirstLastEvent()
                }
            }

            onContentHeightChanged: {
                if ( theListView.isListCompleted === true ) {
                    theListView.updateFirstLastEvent()
                }
            }

            onCountChanged:{
                if(theListView.isListCompleted){
                    updateFirstLastEvent()
                }
            }

            delegate: EventsRow{
                id: delegateId

                property double distance: model.distance

                frameSizeH: ViaviStyle.layouts.largeMargin
                frameSizeV: ViaviStyle.layouts.mediumMargin
                mainContentHeight: laser0Column.height

                event_name: eventName
                event_alarm: alarm
                event_problemEvent: problemEvent
                event_diagnosisCause: diagnosisCause
                showIf: tButton.toggled ? (alarm < 0) : true

                property real firstColumn2WidthScale: 1.5 * rootItem.scaleFactor

                // 1st laser is always visible + 2nd/3rd/4th laser columns visibility
                property int noOfVisibleLasers: 1 + firstColumn5.visible + firstColumn6.visible + firstColumn12.visible

                property int laserColumnMinWidth: (width - imageColumn.width - firstColumn1.width
                                                   - separatorRow.width - firstColumn3.maxComponentsWidth
                                                   - (8 + 2) * ViaviStyle.layouts.largeMargin) //9 items so 8 separators + 2 margins
                                                  / ( noOfVisibleLasers + firstColumn2WidthScale) //4 lasers and firstColumn2
                property int laserColumnMaxWidth: laserColumnMinWidth + laserColumnMinWidth / 2

                property int modelIndex: model.index

                //didn't manage to find another way in which to update the First Last event. 
                //The ListView optimizes the drawing and sometimes the contentY/contentHeight doesn't update
                Component.onCompleted: {
                    if((theListView.contentY <= y && y <= theListView.contentY + theListView.height )
                            || (y <= theListView.contentY + theListView.height  && theListView.contentY + theListView.height <= y + height )){
                        theListView.updateFirstLastEvent()
                    }
                }

                onYChanged: {
                    if((theListView.contentY <= y && y <= theListView.contentY + theListView.height )
                            || (y <= theListView.contentY + theListView.height  && theListView.contentY + theListView.height <= y + height )){
                        theListView.updateFirstLastEvent()
                    }
                }

                rectData : [
                    PopupMouseArea {
                        anchors.fill: parent
                        z:1
                        visible: true
                        enabled: true

                        longPressMenu: eventPopup

                        onBeforePressAndHold: {
                            schematic_cfg_slmCurrentEvent.value = model.eventId - 1
                            delegateId.expanded = true
                        }

                        onClicked: {
                            if(delegateId.expanded)
                                delegateId.expanded = false;
                            else delegateId.expanded = true;
                        }
                    }
                ]

                Column{
                    id: imageColumn

                    Layout.preferredWidth: imageContainer.width
                    bottomPadding: ViaviStyle.layouts.mediumMargin

                    FiberContainer{
                        id: imageContainer

                        height: ViaviStyle.layouts.imageButtonHeight
                        width: 2 * height

                        border.width: ViaviStyle.layouts.borderSmallWidth

                        FiberColorImage {
                            id: eventIcon
                            anchors.fill: parent
                            anchors.margins: ViaviStyle.layouts.smallMargin * 2
                            source: icon
                            fillMode: Image.PreserveAspectFit
                            smooth: true
                            color: ViaviStyle.colors.activeColor
                        }

                        // Indicator image displayed on top of eventIcon
                        Image {
                            visible: iconIndicator !== ""
                            anchors.fill: parent
                            anchors.margins: ViaviStyle.layouts.smallMargin * 2
                            source: iconIndicator
                            fillMode: Image.PreserveAspectFit
                            smooth: true
                        }

                        // * for manually modified event codes
                        Text {
                            visible: model.isIconManual
                            anchors.bottom: parent.bottom
                            anchors.bottomMargin: -ViaviStyle.layouts.largeBoldFontMetrics.height / 4
                            anchors.left: parent.left
                            anchors.leftMargin: ViaviStyle.layouts.mediumMargin / 2

                            color: ViaviStyle.colors.activeColor
                            font: ViaviStyle.layouts.largeBoldFont
                            text: "*"
                        }
                    }
                }

                ResultsTableColumn{
                    id: firstColumn1

                    isCaptionColumn: true

                    Layout.maximumWidth: maxComponentsWidth
                    Layout.minimumWidth: maxComponentsWidth

                    value1Text: events_res_eventLabel.value
                    value2Text: events_res_distanceLabel.value
                }

                ResultsTableColumn{
                    id: firstColumn2

                    Layout.preferredWidth: parent.width / 5
                    Layout.maximumWidth: parent.width / 5
                    Layout.minimumWidth: laserColumnMinWidth * firstColumn2WidthScale
                    Layout.fillWidth: true

                    isCaptionColumn: false

                    value1Text: eventId
                    value2Text: rootItem.getTableText(model.distance)
                    value1Color: ViaviStyle.colors.mainInfoColor
                    value2Color: ViaviStyle.colors.mainInfoColor
                }

                Item{
                    id: separatorRow

                    Layout.fillHeight: true

                    Layout.preferredWidth: separator1.width + 2 * ViaviStyle.layouts.largeMargin
                    Layout.maximumWidth: separator1.width + 2 * ViaviStyle.layouts.largeMargin
                    Layout.minimumWidth: separator1.width
                    Layout.fillWidth: true

                    VerticalSeparator{
                        id : separator1

                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.top : parent.top
                        anchors.bottom : parent.bottom
                        anchors.topMargin: ViaviStyle.layouts.mediumMargin
                        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin
                    }
                }

                ResultsTableColumn{
                    id: firstColumn3

                    Layout.preferredWidth: parent.width / 5
                    Layout.minimumWidth: maxComponentsWidth
                    Layout.fillWidth: true

                    isCaptionColumn: true

                    value1Text: events_res_lossLabel.value
                    value2Text: events_res_reflectLabel.value
                }

                ResultsTableColumn{
                    id: laser0Column

                    Layout.minimumWidth: laserColumnMinWidth
                    Layout.preferredWidth: laserColumnMinWidth
                    Layout.maximumWidth: laserColumnMaxWidth

                    isCaptionColumn: false

                    onWidthChanged: {
                        if (visible) {
                            laserId0.width = width
                        }
                        //should find a more robust system and completly redo the whole component when there's time
                    }

                    value1Text: rootItem.getTableText(model.loss0)
                    value2Text: rootItem.getTableText(model.reflectance0)
                    value1Color:  rootItem.getTextColor(model.alarm_loss0, model.loss0)
                    value2Color: rootItem.getTextColor(model.alarm_reflect0, model.reflectance0)
                }

                ResultsTableColumn{
                    id: firstColumn5

                    Layout.minimumWidth: laserColumnMinWidth
                    Layout.preferredWidth: laserColumnMinWidth
                    Layout.maximumWidth: laserColumnMaxWidth

                    onWidthChanged: {
                        if (visible) {
                            laserId1.width = width
                        }
                    }


                    visible : events_res_laserLabel1.value !== ""

                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss1)
                    value2Text: rootItem.getTableText(model.reflectance1)
                    value1Color: rootItem.getTextColor(model.alarm_loss1, model.loss1)
                    value2Color: rootItem.getTextColor(model.alarm_reflect1, model.reflectance1)
                }

                ResultsTableColumn{
                    id: firstColumn6

                    Layout.minimumWidth: laserColumnMinWidth
                    Layout.preferredWidth: laserColumnMinWidth
                    Layout.maximumWidth: laserColumnMaxWidth

                    onWidthChanged: {
                        if (visible) {
                            laserId2.width = width
                        }
                    }


                    visible : events_res_laserLabel2.value !== ""

                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss2)
                    value2Text: rootItem.getTableText(model.reflectance2)
                    value1Color: rootItem.getTextColor(model.alarm_loss2, model.loss2)
                    value2Color: rootItem.getTextColor(model.alarm_reflect2, model.reflectance2)
                }

                ResultsTableColumn{
                    id: firstColumn12

                    Layout.minimumWidth: laserColumnMinWidth
                    Layout.preferredWidth: laserColumnMinWidth
                    Layout.maximumWidth: laserColumnMaxWidth

                    onWidthChanged: {
                        if (visible) {
                            laserId3.width = width
                        }
                    }


                    visible : events_res_laserLabel3.value !== ""

                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss3)
                    value2Text: rootItem.getTableText(model.reflectance3)
                    value1Color: rootItem.getTextColor(model.alarm_loss3, model.loss3)
                    value2Color: rootItem.getTextColor(model.alarm_reflect3, model.reflectance3)
                }

                overlayData:[
                    Item{
                        anchors.fill: parent

                        Rectangle{
                            anchors.left: parent.left
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom

                            width: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                        }

                        Rectangle{
                            anchors.right: parent.right
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom

                            width: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                        }

                        Rectangle{
                            anchors.right: parent.right
                            anchors.left: parent.left
                            anchors.top: parent.top

                            height: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetBegin
                        }
                        Rectangle{
                            anchors.right: parent.right
                            anchors.left: parent.left
                            anchors.bottom: parent.bottom

                            height: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetEnd
                        }
                    }
                ]
            }
        }
    }
}

