import QtQuick 2.3

import "ViaviStyle"

FiberContainer {
    id: rootItem

    property int event_alarm: 0
    property string event_name : ""
    property string event_problemEvent: ""
    property string event_diagnosisCause: ""

    property bool detailsVisible: false

    width: parent.width
    height: parent.height

    Connections {
        target: schematic_cfg_slmCurrentEvent
        onValueChanged: detailsVisible = false
    }

    Rectangle {
        id: colorStatusRect
        height: parent.height
        width: parent.width / 4
        anchors.left: parent.left
        color: ViaviStyle.colors.getColor(event_alarm)

        FiberColorImage {
            id:eventIcon
            height: ViaviStyle.layouts.imageButtonHeight
            width: parent.width
            anchors.centerIn: parent
            fillMode: Image.PreserveAspectFit
            source: ViaviStyle.images.getAlarmIcon(event_alarm)
            color: ViaviStyle.colors.activeItemTextColor
        }
    }

    Item {
        id: detailTextColumn
        anchors.left: colorStatusRect.right
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.margins: ViaviStyle.layouts.smallMargin

        Text {
            id: eventNameText
            anchors.fill: parent
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layouts.largeFont
            color: ViaviStyle.colors.mainInfoColor
            wrapMode: Text.WordWrap
            text: event_name
        }

        FiberImageButton {

            enabled: event_problemEvent.length > 0 || event_diagnosisCause.length > 0
            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layouts.mediumMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.mediumMargin
            source: ViaviStyle.images.aboutIcon

            isChecked: detailsVisible
            onClicked: detailsVisible = !detailsVisible
        }
    }
}
