import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import "ViaviStyle"

FiberContainer {
    id: rootItem

    property string event_problemEvent: ""
    property string event_diagnosisCause: ""

    width: parent.width
    height: parent.height

    ColumnLayout {
        id: detailTextColumn
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.margins: ViaviStyle.layouts.veryLargeMargin

        Text {
            id: eventProblemText
            Layout.fillWidth: true
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layouts.largeFont
            color: ViaviStyle.colors.mainInfoColor
            wrapMode: Text.WordWrap
            text: event_problemEvent
            visible: text && text.length > 0
        }

        Text {
            id: diagnosisCause
            Layout.fillWidth: true
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layouts.mediumFont
            color: ViaviStyle.colors.secondaryInfoColor
            wrapMode: Text.WordWrap
            text: event_diagnosisCause
            visible: text && text.length > 0
        }
    }
}
