import QtQuick 2.3
import QtQuick.Controls 2.0
import "ViaviStyle"

Item
{
    id: lockButton

    property CursorDragFiber topCursor
    property CursorDragFiber bottomCursor

    property alias pressed: mouseArea.pressed
    property bool locked: topCursor ? topCursor.connectedCursor : false



    signal sgnToggle()

    width: height * 2
    anchors.top: parent.top
    anchors.topMargin: ViaviStyle.layouts.smallMargin
    anchors.bottom: parent.bottom
    anchors.bottomMargin: ViaviStyle.layouts.smallMargin

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        // negative margins will expand the mouse area according to requirements,
        // meaning a smaller icon while keeping the initial press area size
        anchors.margins: -ViaviStyle.layouts.smallMargin * 2
        onReleased: {
            sgnToggle()
        }
    }

    Row{
        anchors.fill: parent

        FiberColorImage {
            visible: lockButton.locked
            height: parent.height
            source: ViaviStyle.images.cursorsLockedBtnImg
            color: lockButton.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
            fillMode: Image.PreserveAspectFit
        }

        FiberColorImage {
            visible: !lockButton.locked
            height: parent.height
            source: ViaviStyle.images.cursorsUnlockedBtnImg
            color: lockButton.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
            fillMode: Image.PreserveAspectFit
        }

        Item{
            height: parent.height
            width: lockedConnectionImgId.width

            FiberColorImage {
                id: lockedConnectionImgId

                visible: lockButton.locked
                height: parent.height
                source: ViaviStyle.images.cursorsLockedConnectionBtnImg
                color: lockButton.pressed ? ViaviStyle.colors.selectedColor : "transparent"
                fillMode: Image.PreserveAspectFit
            }

            FiberColorImage {
                visible: topCursor
                         ? (!lockButton.locked
                               && topCursor.parentTrace.lastUsedCursor === topCursor)
                           || (lockButton.locked
                                && (topCursor.parentTrace.lastUsedCursor === topCursor
                                     || topCursor.parentTrace.lastUsedCursor === topCursor.connectedCursor))
                         : false
                height: parent.height
                source: ViaviStyle.images.cursorASelectedImg
                color: lockButton.pressed ? ViaviStyle.colors.selectedColor : topCursor.color
                fillMode: Image.PreserveAspectFit
            }

            FiberColorImage {
                visible: bottomCursor
                         ? (!lockButton.locked
                                && bottomCursor.parentTrace.lastUsedCursor === bottomCursor)
                           || (lockButton.locked
                                && (bottomCursor.parentTrace.lastUsedCursor === bottomCursor
                                     || bottomCursor.parentTrace.lastUsedCursor === bottomCursor.connectedCursor))
                         : false
                height: parent.height
                source: ViaviStyle.images.cursorBSelectedImg
                color: lockButton.pressed ? ViaviStyle.colors.selectedColor : bottomCursor.color
                fillMode: Image.PreserveAspectFit
            }
        }
    }
}
