import QtQuick 2.3
import QtQuick.Controls 2.0

import "ViaviStyle"

Text {
    id: cursorAInfoText

    property CursorDragFiber cursor

    verticalAlignment: Text.AlignVCenter

    minimumPixelSize : ViaviStyle.layouts.smallFontSize / 2

    fontSizeMode: Text.Fit
    font: ViaviStyle.layouts.cursorInfoFont

    text: cursor
              ? (cursor.text + ": " + Math.round(cursor.displayedXValue * 100) / 100 + " " + trace_res_unitDisplayedX.value + " " +
                    + Math.round(cursor.displayedYValue * 1000) / 1000 + " " + trace_res_unitDisplayedY.value)
              : ""
    color: ViaviStyle.colors.mainInfoColor

}
