import QtQuick 2.1
import graph_plugin 1.0
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id: cursorDrag

    property color color: ViaviStyle.colors.redCursorColor
    property alias text: cursorName.text

    property Item connectedCursor
    property ElfData updateElf
    property Item parentTrace
    property ValueAxis xAxis

    property double displayedXValue: (xAxis && xAxis.rangeOrder === ValueAxis.Decreasing)
                                     ? xAxis.maxValue + xAxis.minValue - parent.posValue
                                       : parent.posValue
    property double displayedYValue: parent.yValues[parent.primaryPlotIndex] !== undefined  ? parent.yValues[parent.primaryPlotIndex] : 0



    property int backendId:-1

    property real connectedCursorOffset

    anchors.top: parent.top
    anchors.bottom: parent.bottom

    visible: status_res_cursorsEnabled.value && parent.opacity !== 0.0
    clip: true

    width: 33
    transform: Translate { x: -(cursorDrag.width-1)/2 }

    signal clicked(var mouse)
    signal released(var mouse)
    property alias pressed: dragArea.pressed
    property bool selected: parentTrace.lastUsedCursor === cursorDrag
                                || parentTrace.lastUsedCursor === connectedCursor

    function colorWithAlpha(color, alpha) {
        return Qt.rgba(color.r, color.g, color.b, alpha)
    }

    function updateConnectedCursorOffset(){
        if(connectedCursor){
            connectedCursorOffset = cursorDrag.x - connectedCursor.x
        }
    }

    signal sgnUpdatePosFromUser(int screenPos, ElfData updateElf)

    function updatePosition(newPos, fromUser, propagate){
        x = newPos
        if(fromUser){
            sgnUpdatePosFromUser(x, updateElf)

            if(propagate && connectedCursor){
                connectedCursor.updatePosition(x - connectedCursorOffset, fromUser, false)
            }
        }
    }

    Text {
        id: cursorName

        color: cursorDrag.color
        font: selected ? ViaviStyle.layouts.mediumBoldFont: ViaviStyle.layouts.smallFont
        x: parent.width - contentWidth
    }

    Rectangle {
        id: cursorHighlight
        anchors.centerIn: parent
        width: parent.height
        height: parent.width - 20
        rotation: 90
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: colorWithAlpha(cursorDrag.color, 0.0) }
            GradientStop { position: 0.45; color: colorWithAlpha(cursorDrag.color, 0.5)}
            GradientStop { position: 0.5; color: colorWithAlpha(cursorDrag.color, 1.0) }
            GradientStop { position: 0.55; color: colorWithAlpha(cursorDrag.color, 0.5) }
            GradientStop { position: 1.0; color: colorWithAlpha(cursorDrag.color, 0.0) }
        }
        Behavior on opacity {
            NumberAnimation { duration: 250 }
        }
    }

    MouseArea {
        id: dragArea
        anchors.fill: parent
        drag.target: parent
        drag.axis: Drag.XAxis
        drag.minimumX: 0
        drag.maximumX: cursorDrag.parent.width-1
        onPressed: cursorHighlight.opacity = 1;
        onReleased: cursorHighlight.opacity = 0;
    }

    onXChanged: {
        GraphCursor.cursor.setPosOnScreen(x)
        // anchor drag to graph cursor
        x = GraphCursor.cursor.posOnScreen

        if(pressed){
            updatePosition(x, true, true)
        }
    }

    GraphCursor.onXPosOnScreenChanged: {
        cursorDrag.x = GraphCursor.cursor.posOnScreen
    }

    onPressedChanged: {
        if(parentTrace){
            parentTrace.lastUsedCursor = cursorDrag
        }
        updateConnectedCursorOffset()
    }

    Component.onCompleted:
    {
        dragArea.clicked.connect(clicked)
        dragArea.released.connect(released)
        if(parentTrace){
            sgnUpdatePosFromUser.connect(parentTrace.onUpdateCursorPosFromUser)
        }
    }
}
