import QtQuick 2.5
import QtQuick.Controls 2.0
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id: rootId

    property bool checked: false

    property alias text: nameLabel.text
    property alias font: nameLabel.font
    property color uncheckedColor: ViaviStyle.colors.secondaryInfoColor
    property alias textElement: nameLabel
    property alias mouseArea: mouseAreaId

    property bool centerContent: false

    width: nameLabel.width

    Text {
        id: nameLabel

        width: contentWidth
        height: contentHeight
        color: enabled || checked ? ViaviStyle.colors.activeColor : uncheckedColor

        font: ViaviStyle.layouts.veryLargeFont
        verticalAlignment: Text.AlignVCenter
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: centerContent ? undefined : parent.left
        anchors.verticalCenter: parent.verticalCenter
    }

    Rectangle {
        width: Math.max(rootId.width / 2, nameLabel.width)
        height: 2 * ViaviStyle.layouts.borderSize
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layouts.smallMargin
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: centerContent ? undefined : parent.left
        color: ViaviStyle.colors.activeColor
        visible: checked
    }

    PopupMouseArea {
        id: mouseAreaId
        anchors.fill: parent
        z: parent.z + 1
    }
}
