import QtQuick 2.3
import libfo 1.0
import "./UtilUiQt/Viavi_Colors.js" as VColor

Rectangle {
	id: cable
	property int nb_col: 7
	color: "black"
	focus: true

	Column {

		Cable_Co_Title {
			id: title
			height: grid.cellHeight / 3
			width: grid.cellWidth * nb_col
		}

		GridView {
			id: grid
			width : cable.width
			height : cable.height - cable_head.height - title.height
			currentIndex: cable_co_list.Index
			boundsBehavior: Flickable.StopAtBounds
			cellWidth : (cable.width / nb_col) - 1
			cellHeight : (cable.width / nb_col) - 1
			
			clip: true
	        
	        highlightMoveDuration: -1

			model: cable_co_list.Cable_List
			delegate: Cable_Co_One_Element {}
		}

		Cable_Co_Result_Informations {
			id: cable_head
			
			visible: cable_co_list.Result_Window_Displayed

			height: visible ? grid.cellHeight * 1.3 : 0
			width: grid.cellWidth * nb_col
		}
	}

	Keys.onPressed: {
		console.log("!!! Keys: " + event.key)
		if (event.key == Qt.Key_Left) {
			if (cable_co_list.Index > 0) {
				cable_co_list.Index = cable_co_list.Index - 1;
			}
		} else if (event.key == Qt.Key_Right) {
			if (cable_co_list.Index < (grid.count - 1)) {
				cable_co_list.Index = cable_co_list.Index + 1;
			}
		} else if (event.key == Qt.Key_Up) {
			if ((cable_co_list.Index - nb_col) >= 0) {
			    cable_co_list.Index = cable_co_list.Index - nb_col;
			}
		} else if (event.key == Qt.Key_Down) {
			if ((cable_co_list.Index + nb_col) < grid.count) {
			    cable_co_list.Index = cable_co_list.Index + nb_col;
			}
		}
	}
}
