import QtQuick 2.3
import libfo 1.0
import "./UtilUiQt/Viavi_Colors.js" as VColor
import 'ViaviStyle'

Item {
    CableToggleFiberPopup { id: enablePopupId }

    property int fiber_index: 0
    property bool selected: ( fiber_index === cable_co_list.Index ) && ( cable_co_list.Label_Selection_Mode === false )

    readonly property real cellFontRatio: 2.5

    width: ( cable_co_list.MPO_Size > 4 ? 48 : 90 )
    height: width

    // Use Q_ENUM when enum not negative or supported in QML
    function cable_alarm_color ( cable_co_list, i ) 
	{
		var cable_back_col = VColor.cViaviColorLightGray2;	
	
		if (cable_co_list.Cable_List[i] != undefined) 
		{
		  if (!cable_co_list.Cable_List[i].Fiber_To_Test) 
		  {
		      cable_back_col = VColor.cViaviColorGray;
		  } 
		  else if (cable_co_list.Cable_List[i].Fiber_Test_Done) 
		  {
		    var alarm = cable_co_list.Cable_List[i].Alarm_Status;
		    
	    	if (alarm == 1) {
				cable_back_col = VColor.cViaviColorGreen;
			}
			else if (alarm == -1) {
				cable_back_col = VColor.cViaviColorRed;
			}
			else if (alarm == -2) {
				cable_back_col = VColor.cViaviColorYellow;
			}
			else
			{
				cable_back_col = VColor.cViaviColorLightBlue;
			}
		  }
		}
		
		return cable_back_col;
    }

    Rectangle {
        anchors.centerIn: parent
        color: cable_alarm_color( cable_co_list, fiber_index )

        width: Math.min(parent.width, parent.height) - ViaviStyle.layouts.smallMargin
        height: width

        Rectangle {
            visible: selected

            width: parent.width
            height: parent.height / 6

            color: VColor.cViaviColorMediumBlue
            anchors.bottom: parent.bottom
        }

        Text {
            anchors.fill: parent
            text: (cable_co_list.Cable_List[fiber_index] !== undefined ? cable_co_list.Cable_List[fiber_index].Fiber_Channel : "")

            color: (selected ) ? VColor.cViaviColorMediumBlue : VColor.cViaviColorLogoPurple
            font.pixelSize: width / cellFontRatio
            font.family: "Bitstream Vera Sans Roman"
            font.bold: true

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
        }
        
        PopupMouseArea {
            anchors.fill: parent
            longPressMenu: enablePopupId
            z: parent.z + 1
            onBeforePressAndHold: {
                cable_co_list.Label_Selection_Mode = false
                cable_co_list.Index = fiber_index
            }
	        onClicked: {
	        	cable_co_list.Label_Selection_Mode = false
	            cable_co_list.Index = fiber_index
	        }
	    }
    }
}
