<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\view;

use app\admin\SMTOtuMode;

use app\admin\SMTLanguage;
use app\http\SMTContext;

/**
 * Generates an html test page;
 *
 * @author Sylvain Desplat
 */
class SMTLoginPage implements SMTIPage
{
	const LOGIN_FILE = "app/view/SMTLoginLayout.php";
	
	/**
	 * 
	 * @var string
	 */
    private $htmlFile;
    
    /**
     * 
     * @var app\http\SMTContext
     */
    private $context;
    
    /**
     * Error login message if user authentication has failed.
     * @var string
     */
    private $errorLoginMessage;
    
    /**
     * Login page: display login form and last login trial error message if needed 
     * 
     * @param SMTContext $context
     * @param string $errorLoginMessage
     */	
	function __construct( $context, $errorLoginMessage )
	{
		$this->htmlFile = self::LOGIN_FILE;
		$this->context = $context;
		$this->errorLoginMessage = $errorLoginMessage;
	}
		
	/**
	 * Generate the login page
	 *
     * @return page generation status
	 */
	function generatePage()
	{
	    $gwtCodesvr = $this->context->getHttpRequest()->getData('gwt.codesvr');
	    $target = $this->context->getHttpRequest()->postSafeData('target');	    
            /*
	    if ( $target == NULL )
	    {
	        $target = $this->context->getHttpRequest()->getSafeData('target');
	    }
	    */
 
		//retrieve variables used in htmlFile
        $currentLanguage = SMTLanguage::getCurrentLanguage();
        $supportedLanguages = SMTLanguage::getSupportedLanguages();
        //Pour ne plus risquer des problemes d'injection, on n'affiche plus le precedent login, meme en cas d'erreur
        //$loginStr = $this->context->getHttpRequest()->postSafeData('login');
        $loginStr = "";
        $smartModeLogo      = SMTOtuMode::getOtuModeLogo();
        $smartModeDisplay   = SMTOtuMode::getOtuModeDisplay();
        $loginWindowTitle   = sprintf(MSG_LOGIN_WINDOW_TITLE, SMTOtuMode::getOtuModeDisplay()); 
        
        $errorLoginMessage=$this->errorLoginMessage;
 
        //populate the login layout page
        //include "app/view/header.php";
		include $this->htmlFile;
	}
}

?>
