<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\admin\SMTOtuType;
use app\services\maintenance\SMTUploadStatusDto;
use app\serviceshelper\maintenance\SMTUpgrade;
use app\util\SMTLogger;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//2 hours script timeout ( OTU release at rate 500kb/s )
set_time_limit(3600);

function shutdown()
{
	//force the cleanup of the release running flag, in case of crash
	SMTUploadStatus::setUploadRelaseRunning(FALSE);
} 

$upgradeDto = SMTUpgrade::getCurrentUpgrade();

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( ($noUploadRunning == TRUE) && !$upgradeDto->isUpgradeInProgressOnOtu() )
{
	register_shutdown_function(__NAMESPACE__.'\\'.'shutdown');
	SMTUploadStatus::setUploadRelaseRunning(TRUE);
	
	if ( SMTOtuType::isCOtu_EOTDRV2() )
	{
		$uploadStatus = upload_file( SMTUpgrade::OTU_RELEASE_CURRENT_DIR, 'check5kRelease');
	}
	else if ( SMTOtuType::isOTH() )
	{
	    $uploadStatus = upload_file( SMTUpgrade::OTU_RELEASE_CURRENT_DIR, 'checkAfthRelease');
	}
	else
	{
		$uploadStatus = upload_file( SMTUpgrade::OTU_RELEASE_CURRENT_DIR, 'check8kRelease');
	}
	SMTUploadStatus::setUploadRelaseRunning(FALSE);
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    if ( $noUploadRunning != TRUE )
    {    	    	
        $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
        SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    }
    else
    {
    	$uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPGRADE_ALREADY_RUNNING );
    	SMTLogger::getInstance()->trace("Upgrade already running...", SMTLogger::ERROR);
    }    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>