<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions2018. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;


/**
 * OTU monitoring test mode: OTDR, HIGHSENS,TAPPING...
 * 
 * @author Sylvain Desplat
 */
class SMTTestMode
{
	/**
	 * test otdr
	 * @var string
	 */
	const OTDR = "OTDR";
	
	/**
	 * DTS test
	 * @var string
	 */
	const DTS = "DTS";
	
	/**
	 * DTSS test
	 * @var string
	 */
	const DTSS = "DTSS";
	
    /**
     * Highsens test
     * @var string
     */
    const HIGHSENS = "HIGH";
    
    /**
     * Tapping test 
     * @var string
     */
    const TAPPING = "HTAP";
    
    
    /**
     * Get the default highsens test type.
     *
     * @return string the default highsens test type
     */
    public static function getDefaultTestMode()
    {
    	return self::HIGHSENS;
    }

    public static function isHighsensOrTappingMode( $mode )
    {
    	return ( (strcasecmp(self::HIGHSENS, $mode) == 0) || (strcasecmp(self::TAPPING, $mode) == 0) );
    }
    
    public static function isOtdrMode( $mode )
    {
    	return ( (strcasecmp(self::OTDR, $mode) == 0) );
    }
    
    public static function isTappingMode( $mode )
    {
    	return ( (strcasecmp(self::TAPPING, $mode) == 0) );
    }
    
    public static function isHighsensMode( $mode )
    {
    	return ( (strcasecmp(self::HIGHSENS, $mode) == 0) );
    }
    
    public static function convertFromScpi($scpi_constant)
    {
    	if ( strcasecmp(self::OTDR, $scpi_constant) == 0)
    	{
    		return self::OTDR;
    	}
    	if ( strcasecmp(self::DTS, $scpi_constant) == 0)
    	{
    		return self::DTS;
    	}
    	if ( strcasecmp(self::DTSS, $scpi_constant) == 0)
    	{
    		return self::DTSS;
    	}
    	if ( strcasecmp(self::TAPPING, $scpi_constant) == 0)
    	{
    		return self::TAPPING;
    	}
    	else // if ( strcasecmp(self::HIGHSENS, $scpi_constant) == 0)
    	{
    		return self::HIGHSENS;
    	}
    }
}
?>