<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTOnmsiServerListDto extends SMTDto
{
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTOnmsiServerDto',islist='true')
	 * @var array app\services\setup\SMTOnmsiServerDto
	 */
	protected $onmsiServerList = array();

    /**
     * 
     * @var Boolean whether a backup route is available. FALSE by default
     */
	protected $backupRoute = FALSE;
	
	/**
	 *
	 * @var Boolean whether ssh strong is setup on ONMSi server (ONMSi Linux). FALSE by default
	 */
	protected $sshStrong = FALSE;	
	
	/**
	 * @param app\services\setup\SMTOnmsiServerDto
	 */
	public function addServer( SMTOnmsiServerDto $server )
	{
		array_push( $this->onmsiServerList, $server);
	}	
	
	/**
	 * @param boolean $backupRoute
	 */
	public function setBackupRoute( $backupRoute)
	{
		$this->backupRoute= $backupRoute;
	}
	
	/**
	 * @param boolean $sshStrong
	 */
	public function setSshStrong( $sshStrong)
	{
		$this->sshStrong= $sshStrong;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>