<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\settings\SMTSmartOtuSettings;

use app\serviceshelper\media\SMTMediaException;
use app\serviceshelper\media\SMTEmail;

use app\view\SMTTestRestApiPage;
use app\services\SMTIService;
use app\services\SMTService;

/**
 * Service to setup the OTU Email features and display its configuration.
 * 
 * @author Sylvain Desplat
 */
class SMTEmailService extends SMTService implements SMTIService
{
    /**
     * Create empty Dto Email to be sent to the client
     *
     * @url GET /new
     * @access protected
     * @class SMTAccessControl {@requires install}
     */
    function newEmail()
    {        
    	try
    	{
    	    $email = new SMTEmail();
    	    $email->setContext( $this->getContext() );
    	    $emailDto = $email->newEmail();
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    	return $emailDto->getJsonData();
    }    
    
    /**
     * Full json request data are by default stored in an array in parameter Default::$fullRequestDataName='request_Data'
     * Update full Email config
     *
     * @url POST
     * @access protected
     * @class SMTAccessControl {@requires install}
     */
    function updateEmails( $request_data )
    {
        $email = new SMTEmail();
        $email->setContext( $this->getContext() );
    	try
    	{
    	    $dbConnection = $this->getContext()->getDatabase();
    	    
    		$emailConfDto = SMTConfEmailDto::getInstance( $request_data );

            //update email first!
            //nevertheless, with the current version of exim it works: config is reloaded for the very first email...
    		$email->updateEmails( $emailConfDto, $dbConnection );
    		//setting the media
    		$email->setEmailMedia( $emailConfDto->isEmailActive());

    		//fetch applied config
    		$emailConfData = $email->retrieveEmails( $dbConnection );
    		
    		$dbConnection->close();
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}

    	//return email configuration
    	return $emailConfData->getJsonData();
    }        
    
    /**
     * Fetch Emails configurations
     *
     * @url GET
     * 
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function fetchEmails()    
    {
        $email = new SMTEmail();
        $email->setContext( $this->getContext() );
        
        try
        {
            $emailConfDto = $email->retrieveEmails();
    	}
    	catch ( \Exception $e )
    	{
    	    $this->handleException($e);
    	}
    
    	return $emailConfDto->getJsonData();
    }
    
    /**
     * Perform a Test of Email media: send an Email
     *
     * @url POST /{emailNumber}/test
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function testEmail( $emailNumber )
    {
        try
        {                        
            $email = new SMTEmail();
            $email->setContext( $this->getContext() );
            $testEmailDto = $email->testEmail( $emailNumber );
    	}
    	catch ( \Exception $e )
    	{
    	    $this->getContext()->traceException($e);
    		if ( !( $e instanceof SMTMediaException ) )
    	    {
    	        $e = new SMTMediaException( SMTMediaException::ERROR_INVALID_CONFIG );
    	    }    		   
    		$this->handleException($e);  	    
    	}
    	return $testEmailDto->getJsonData();    			
    }
    
    /**
     * @url GET /test/updateemail
     */
    function testUpdateEmail()
    {
        if ( SMTSmartOtuSettings::isDebugMode() )
        {
        	$emailConfDto = new SMTConfEmailDto();
        	for ( $index = SMTEmail::MIN_EMAIL_INDEX; $index <= SMTEmail::MAX_EMAIL_INDEX; $index++)
        	{
        		$emailDto = new SMTEmailDto();
        		$emailDto->setValid( FALSE);
        		$emailDto->setIndex( $index );
        		$emailDto->setAddressFrom( "" );
        		$emailDto->setAddressTo( "" );
        		$emailDto->setSubject( "" );
        		$emailConfDto->addEmail( $emailDto );
        	}
        	
        	$url = '/emails';
        	$json_string = json_encode( $emailConfDto->getJsonData() );
        	$page = new SMTTestRestApiPage($url, $json_string, 'POST');
        	$this->getContext()->getHttpResponse()->send( $page );
        }
    }
    
    /**
     * @url GET /test/emailtest
     */
    function testEmailTest()
    {
        if ( SMTSmartOtuSettings::isDebugMode() )
        {
        	$url = '/emails/1/test';
        	$page = new SMTTestRestApiPage($url, "", 'POST');
        	$this->getContext()->getHttpResponse()->send( $page );
        }
    }    
}

?>