<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\admin\SMTOtuType;

use app\util\SMTDto;

/**
 * DTO to retrieve OTU main info
 *
 * @author Sylvain Desplat
 */
class SMTOtuInfoDto extends SMTDto
{
	/**
	 * Company: JDSU
	 *
	 * @var string
	 */
	protected $company;

	/**
	 * Otu type (8000e)
	 *
	 * @var string
	 */
	protected $otuType = SMTOtuType::DEFAULT_OTU_TYPE;

	/**
	 * Otu serial number
	 *
	 * @var string
	 */
	protected $serialNumber;

	/**
	 * Otu mode (SmartOtu)
	 *
	 * @var string
	 */
	protected $otuMode;

	/**
	 * Otu software Release
	 *
	 * @var string
	 */
	protected $otuSoftwareRelease;

	/**
	 * SmartOtu software Release
	 *
	 * @var string
	 */
	protected $smartOtuSoftwareRelease;
	
	/**
	 * Timestamp to track when the dto was returned
	 * 
	 * @var float
	 */
	protected $currentTimestampUTC;

	public function setCompany( $company )
	{
		$this->company = $company;		
	}

	public function setOtuType( $otuType )
	{
		$this->otuType = $otuType;
	}

	public function setSerialNumber( $serialNumber )
	{
		$this->serialNumber = $serialNumber;
	}

	public function setOtuMode( $otuMode )
	{
		$this->otuMode = $otuMode;
	}

	public function setOtuSoftwareRelease( $otuSoftwareRelease )
	{
		$this->otuSoftwareRelease = $otuSoftwareRelease;
	}

	public function setSmartOtuSoftwareRelease( $smartOtuSoftwareRelease )
	{
		$this->smartOtuSoftwareRelease = $smartOtuSoftwareRelease;
	}
	
	public function setCurrentTimeStampUTC( $timestampUTC )
	{
		$this->currentTimestampUTC = $timestampUTC;
	}

	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}

?>