<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm\otu;

use app\util\SMTRwDto;


/**
 * Optical alarm Dto deviations 
 * 
 * @author Sylvain Desplat
 */
class SMTOtuOpticalAlarmDeviationDto extends SMTRwDto
{
    /**
     * First marker deviation in dB
     * @var float
     */
    protected $firstMarker = NULL;
    /**
     * Link loss deviation in dB
     * @var float
     */    
    protected $linkLoss = NULL;       
    
    /**
     * Whether First marker deviation is valid
     * @var boolean
     */
    protected $firstMarkerValid;
    
    /**
     * Whether Link loss deviation is valid
     * @var boolean
     */
    protected $linkLossValid;
    
    /**
     * Returns the First marker deviation in dB.
     * 
     * @return float
     */
    public function getFirstMarkerDeviation()
    {
        return $this->firstMarker;
    }
    
    /**
     * Returns whether the First marker deviation is valid 
     *
     * @return boolean
     */
    public function isFirstMarkerDeviationValid()
    {
        return filter_var( $this->firstMarkerValid, FILTER_VALIDATE_BOOLEAN );
    }
    
    /**
     * Returns whether the link loss is valid
     *
     * @return boolean
     */
    public function isLinkLossDeviationValid()
    {
        return filter_var( $this->linkLossValid, FILTER_VALIDATE_BOOLEAN );
    }
    
    /**
     * Returns the Link loss deviation in dB.
     *
     * @return float
     */
    public function getLinkLossDeviation()
    {
    	return $this->linkLoss;
    }    
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }

    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuOpticalAlarmDeviationDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}



?>