<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\alarm;

use app\services\alarm\SMTSystemAlarmDto;

use app\util\SMTDto;

class SMTSystemAlarmListDto extends SMTDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTSystemAlarmDto',islist='true')
     * @var array app\services\alarm\SMTSystemAlarmDto
     */
    protected $systemAlarms = array();     

    /**
     * @param array
     */
    public function setSystemAlarms( $systemAlarms )
    {
    	$this->systemAlarms = $systemAlarms;
    }
    
    /**
     * @return array
     */
    public function getSystemAlarms()
    {
    	return $this->systemAlarms;
    }   
    
    /**
     * @param SMTSystemAlarmDto $systemAlarm
     */
    public function addSystemAlarm( SMTSystemAlarmDto $systemAlarm )
    {
    	array_push( $this->systemAlarms, $systemAlarm );
    }  
        
    /**
     * Serialize as Json data the user object.<br> 
     * 
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
        $this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }

    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
        return get_class();
    }      
}


?>