<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\otuMediation;

use app\serviceshelper\monitoring\SMTMeasureOnDemandEventDto;

/**
 * Otu Measure events codes
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtuMeasureOnDemandStatus extends SMTOtuOperationStatus
{          
    const MEAS_ADD_OK = "0000";
    const MEAS_ADD = "0010";
    const PARAM_MISSING = "0020";
    const MOD_MISSING = "0030";
    const LINK_UNKNOWN = "0040";
    const SWITCH_BUFFER_SIZE = "0050";
    const SWITCH_BUFFER_ERROR = "0060";
    const REG_MEAS_FAILED = "0070";
    const WRONG_RANGE = "0080";
    const WRONG_RES = "0090";
    const WRONG_PULSE = "0100";
    const WRONG_LASER = "0110";
    const MEASURE_BAD_TIMESLOT = "0120";
    const MEASURE_BAD_TIME     = "0130";
    const WRONG_FONCTION = "0150";
    const INCOHERENT_FONCTION = "0160";
    const ADD_LOCALISATION_ERROR = "0170";
    const REF_FILE_PARAMETER_ERROR = "0180";
    
    /**
     * Whether the status given is a measurement status
     * 
     * @param string $code mesure status
     * 
     * @return boolean
     */
    public static function isValidMeasureStatus( $otuCode )
    {                
        $valid = FALSE;
        switch( $otuCode )
        {
        	case self::MEAS_ADD_OK:
        	case self::MEAS_ADD:
        	case self::PARAM_MISSING:
        	case self::MOD_MISSING:
        	case self::LINK_UNKNOWN:
        	case self::SWITCH_BUFFER_SIZE:
        	case self::SWITCH_BUFFER_ERROR:
        	case self::REG_MEAS_FAILED:
        	case self::WRONG_RANGE:        	
    	    case self::WRONG_RES:
	        case self::WRONG_PULSE:    	        
    	    case self::WRONG_LASER:
	        case self::MEASURE_BAD_TIMESLOT:
	        case self::MEASURE_BAD_TIME:
	        case self::WRONG_FONCTION:
            case self::INCOHERENT_FONCTION:
            case self::ADD_LOCALISATION_ERROR:
            case self::REF_FILE_PARAMETER_ERROR:        	            	         	        
        	    $valid = TRUE;
        		break;
        	default:
        		$valid = self::isValidOperationStatus($otuCode);
        		break;
        }
        return $valid;        
    } 
    
    /**
     * Translates status code. If the code is not found, returns an empty string.
     * 
     * @param String $otuCode The status code to translate
     * 
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public static function decodeOtuStatus( $otuCode )
    {
        $code = MSG_ERROR_MEASURE_FAILED.$otuCode;
        
        switch( $otuCode )
        {
            case self::MEAS_ADD_OK:
            	$code = SMTMeasureOnDemandEventDto::MEAS_ADD_OK;
            	break;
            case self::MEAS_ADD:
            	$code = SMTMeasureOnDemandEventDto::MEAS_ADD;
            	break;
            case self::PARAM_MISSING:
            	$code = SMTMeasureOnDemandEventDto::PARAM_MISSING;
            	break;
            case self::MOD_MISSING:
            	$code = SMTMeasureOnDemandEventDto::MOD_MISSING;
            	break;
            case self::LINK_UNKNOWN:
            	$code = SMTMeasureOnDemandEventDto::LINK_UNKNOWN;
            	break;
            case self::SWITCH_BUFFER_SIZE:
            	$code = SMTMeasureOnDemandEventDto::SWITCH_BUFFER_SIZE;
            	break;
            case self::SWITCH_BUFFER_ERROR:
            	$code = SMTMeasureOnDemandEventDto::SWITCH_BUFFER_ERROR;
            	break;
            case self::REG_MEAS_FAILED:
            	$code = SMTMeasureOnDemandEventDto::REG_MEAS_FAILED;
            	break;
            case self::WRONG_RANGE:
            	$code = SMTMeasureOnDemandEventDto::WRONG_RANGE;
            	break;
            case self::WRONG_RES:
            	$code = SMTMeasureOnDemandEventDto::WRONG_RES;
            	break;
            case self::WRONG_PULSE:
            	$code = SMTMeasureOnDemandEventDto::WRONG_PULSE;
            	break;
            case self::WRONG_LASER:
            	$code = SMTMeasureOnDemandEventDto::WRONG_LASER;
            	break;
            case self::MEASURE_BAD_TIMESLOT:
            	$code = SMTMeasureOnDemandEventDto::MEASURE_BAD_TIMESLOT;
            	break;
        	case self::MEASURE_BAD_TIME:
        		$code = SMTMeasureOnDemandEventDto::MEASURE_BAD_TIME;
        		break;            	            	
            case self::WRONG_FONCTION:
            	$code = SMTMeasureOnDemandEventDto::WRONG_FONCTION;
            	break;
            case self::INCOHERENT_FONCTION:
            	$code = SMTMeasureOnDemandEventDto::INCOHERENT_FONCTION;
            	break;
            case self::ADD_LOCALISATION_ERROR:
            	$code = SMTMeasureOnDemandEventDto::ADD_LOCALISATION_ERROR;
            	break;
            case self::REF_FILE_PARAMETER_ERROR:
            	$code = SMTMeasureOnDemandEventDto::REF_FILE_PARAMETER_ERROR;
            	break;  			 
            default:
                $code = SMTOtuOperationStatus::decodeOtuStatus( $otuCode );
                break;
        }
        return $code;
    }
    
    /**
     * Whether measurement addition was successful 
     *
     * @param string $otuCode mesurement add status
     *
     * @return boolean
     */
    public static function isMeasurementAdditionStatusOK( $otuCode )
    {
    	return self::MEAS_ADD_OK == $otuCode;
    }    
}

?>